#ifndef _ESCENARIOS_H_
#define _ESCENARIOS_H_

#include "../main/glaurung.h"
#include "../sprites/sprites.h"

// Estructura de almacenamiento de estado de enemigos
//
class TEstadoEnemigo:public TMAObject
{
    REGISTER_CLASS protected:
    public:
        PUBLIC_CLASS_ID;
        static const char NADA = '0';
        static const char ARQUERO = 'A';
        static const char LANCERO = 'L';
        static const char CABALLERO = 'C';
        static const char SPIDER = 'S';
        static const char BAT0 = 'M';
        static const char BAT1 = 'N';
        static const char MAGMA = 'F';
        
        int tipo;
        bool vivo;
        
        TEstadoEnemigo();
};

// Estructura de almacenamiento de datos de pantallas: TScreenInfo
//
class TScreenInfo:public TMAObject
{	
    REGISTER_CLASS protected:
                
        // --- Constructor
        //
        TScreenInfo();     

        static void ordenateTreasures(TScreenInfo *GA_InfoScr);

        
        // ------- Guardado y Recuperacion
        //
        void readFromFile(FILE*);
        void writeToFile(FILE*);
        
    public:
        PUBLIC_CLASS_ID;
                        
        static const int MAX_ENEMIGOS=6;
        static const int MAX_PANTALLAS=240;

        // Existencia de cofre en la pantalla.
        //
        static const int SIN_COFRE = 0;
        static const int COFRE_CERRADO = 1;
        static const int COFRE_ABIERTO = 2;
        
        // Estas constantes determinan el tipo de objeto que puede
        // haber dentro de los cofres del tesoro.
        //
        static const int SIN_TESORO      = 0;
        static const int GEMA_ROJA       = 1;
        static const int GEMA_VERDE      = 2;
        static const int GEMA_AZUL       = 3;
        static const int LLAVE_ROJA      = 4;
        static const int LLAVE_AZUL      = 5;
        static const int POCION_AMARILLA = 6;
        static const int POCION_VERDE    = 7;
        static const int BOLSA_ORO       = 8;
        static const int CAJA_FLECHAS    = 9;
        static const int VIDA_EXTRA      = 10;
        static const int HECHIZO_CERDO   = 11;
        static const int SPIDER_ARQUERO  = 12;
        static const int BAT_LANCERO     = 13;
        
        // Pantallas con las que esta enlaza en cada direccin.
        //
        int left,top,right,bottom;
        
        // Gestion de Cofres en la Pantalla
        //
        int cofre,tipo_tesoro;
        
        // Aspecto grafico del mapa
        bool visitada,calculado;
        int posx,posy;
        
        // Gestion de Enemigos en la Pantalla
        //
        TEstadoEnemigo enemigos[MAX_ENEMIGOS];
        
        // ------- Obtiene el array de screeninfo
        //
        static TScreenInfo* getScreenInfo(void);
        static void readFromFile(FILE*,TScreenInfo*);
        static void writeToFile(FILE*,TScreenInfo*);
        static void generateMap(TScreenInfo*);
        static void calculateScreenMap(TScreenInfo*,int);
        static void saveDebug(TScreenInfo*,const char*);
        
};
typedef TScreenInfo* PScreenInfo;        

// Escenario de seleccion de idioma e historia
//
class TESC_Seleccion_Idioma:public TMAScene
{
    REGISTER_CLASS protected:
        
        static const int MAX_SCROLL=14;
        static const int ALTURA_SCROLL=35;
        static const int MAX_GAME_TEXT=25;
        static TMAString ia_himnos[5];
        static int ia_cursor_pos[5];
        static char *ia_lang_name[5];
        
        TGlaurungGame *miGame;        
        TMAGameMap map;
        PMAScreenMap io_Screen;
        
        TMAVector iv_Historia;
        PMAVector iv_Textos;
        PMABitmap masoft;
        int ii_linea,ii_cuenta,li_alpha;
        PSpriteSeleccion sprSeleccion;
        
        void scrollText(TMABitmap&);
        
    public:
        PUBLIC_CLASS_ID;
        TESC_Seleccion_Idioma();
        ~TESC_Seleccion_Idioma();
        
        bool doInit(const PMAObject params);
        bool doRun(void);
        void doPaint(TMABitmap&);
        
        void doRunLanguage(void);
        void doRunHistory(void);        
        void doPaintLanguage(TMABitmap&);
        void doPaintHistory(TMABitmap&);
        
        void playCountryMidi(void);
        void playHistoryMidi(void);
        void languageChanged(void);
        void loadHistory(void);
        
        void gotoShowHistory(void);
        void gotoMainMenu(void);
        void gotoSelectLanguage(void);
};

// Escenario de menu principal
//
class TESC_Menu_Principal:public TMAScene
{
    REGISTER_CLASS protected:
        
        static const int MAX_RULO_SIZE=40;
    
        TGlaurungGame *miGame;
        int *offwave;
        PMABitmap img_portada;    
        PMABitmap img_scroll;
        PMABitmap img_alpha;
        PMABitmap img_credits;
        
        int *offrulo,sizerulo;
        int ii_rulo,ii_scroll_pos,ii_chars_scroll;
        
        PSpriteArquero io_arquero;
        PSpriteFlecha io_flecha;
        int i_estado_arquero;
        int ii_opcion_menu,ii_opcion_menu_old;
        TMARectangle ir_borrado;

        void gotoGame(void);
        void gotoDefineKeys(void);
        void gotoLanguage(void);
        void gotoMenu(bool loadimage);
        void gotoCredits(void);
        void createRollWave(void);
        void createSinTable(int radio,int arcos);
        void rotateSinTable(void);
        int* getBresenhamDistances(int radius_x,int radius_y,int& sizebuff);
        
        void drawMenu(TMABitmap&);
        void drawDefineKeys(TMABitmap&);
        void rollEffect(TMABitmap&);
        void doScroll(TMABitmap&);
        void borraFranja(TMABitmap&);
        void moverArquero(int y,int opcion);
		     
    public:
        PUBLIC_CLASS_ID;
 
        static TMAString gs_menu_options_text[6];
        static TMAString gs_scroll_text;        
 
        TESC_Menu_Principal();
        ~TESC_Menu_Principal();
        
        bool doInit(const PMAObject params);
        void doPaint(TMABitmap&);
        bool doRun(void);  
};

// Escenario de seleccion de idioma e historia
//
class TESC_Juego:public TMAScene
{
    REGISTER_CLASS protected:
        
        TGlaurungGame *miGame;        
        
        static const int _Obj_Flechas           = 1;
        static const int _Obj_Oro               = 2;
        static const int _Obj_Verde             = 3;
        static const int _Obj_Amarillo          = 4;
        
        static const int _Collision_Muerte      = 2;
        static const int _Collision_Burladero   = 3;
        static const int _Collision_Cofre       = 4;
        
        static const int E_SIN_BRUJO_DRAGON = 0;
        static const int E_APARECIENDO_BRUJO = 1;
        static const int E_CON_BRUJO = 2;
        static const int E_APARECIENDO_DRAGON = 3;
        static const int E_CON_DRAGON = 4;
                
        static int pasadizos[5][2];
        
        TMAString snap_name[3];
        PMABitmap snap_bmp[3];
        
        PSpriteBurladero SprBurladero;
        PSpriteSeleccion SprSeleccion;
        PSpriteBrujoDragon SprBrujoDragon;
        PScreenInfo scrInfo;
        PMAScreenMap io_Screen;
        int ii_seleccion,ii_scrBurladero;
        int ii_menu_option,ii_menu_state,ii_snap_index;
        int ii_mapx,ii_mapy;
        bool ib_menu_mode;
        int ii_brujo_dragon,ii_tiempo_brujo_dragon;
        
        TMAVector iv_SpritesFront;
        TMAVector iv_Sprites;
        bool iaEnemyPos[6];       
        
        void enterLeftScreen(void);
        void enterUpScreen(void);
        void enterRightScreen(void);
        void enterDownScreen(void);
        
        void findRedhamPosition(void);
        void findEnemyPosition(PSpriteGlaurung);
        void findBurladero(void);
        void detectCollisions(void);
        void openCofre(bool solo_cambiar_imagen);
        void enterPasadizo(void);
        void exitPasadizo(void);
        void putRedhamOutBurladero(void);
        
        void removeGarbage(bool front=false);
        
        void loadSnap(void);
        void drawSnap(TMABitmap&);
        
        void doRunMenu(void);
        void doRunGame(void);
        void doPaintMenu(TMABitmap&);
        void doPaintMap(TMABitmap&);
        void drawScreen(TMABitmap&);
        void drawGameInfo(TMABitmap&);
        
        void saveGame(int);
        void loadGame(int);
        
        void gotoMainMenu(void);
        void gotoEndGame(void);
        
    public:
        PUBLIC_CLASS_ID;        
        PSpriteRedham SprRedham;        
        
        TESC_Juego();
        ~TESC_Juego();
        
        bool doInit(const PMAObject params);
        bool doRun(void);        
        void doPaint(TMABitmap&);        

        bool enterOnScreen(int scr);
        void addSprite(PSpriteGlaurung,bool front);
        void removeSprite(PSpriteGlaurung,bool front);
        void setEnemyTarget(PSpriteGlaurung);
        
        void killRedham(void);
        void aparecerBrujoDragon(void);
        void desaparecerBrujoDragon(void);
};
typedef TESC_Juego* PESC_Juego;      

// Escenario del Final del Juego
//
class TParticula;
class TFuegoArtificial;

typedef struct {
    int x;
    int y;
} TPoint;

#define MAX_PARTICULA_PATH 50

class TParticula:public TMAObject
{
    REGISTER_CLASS protected:    
    
    friend class TFuegoArtificial;
    
    float px,py,vx,vy,ax,ay;
    int r,g,b,live;
    bool ib_valid;
    
    TPoint path[MAX_PARTICULA_PATH];
    int elems,head,tail;
        
    public:
        PUBLIC_CLASS_ID;
        
        TParticula();        
        void doInit(int x,int y,float velx,float vely,float acx,float acy,int pcolor);
        bool doRun(void);
        void doPaint(TMABitmap&);  
        bool isValid(void) { return ib_valid; }
        void invalidate(void) { ib_valid=false; }
};

class TFuegoArtificial:public TMAObject
{
    REGISTER_CLASS protected:    
        
        const static int MAX_PARTICULAS=300;
        TParticula particulas[MAX_PARTICULAS];
        bool ib_subiendo,ib_valid;
        
    public:
        PUBLIC_CLASS_ID;
        
        static int COLORES[10];
        static float SIN[1024];
	    static float COS[1024];
	    static TMASound snd_Cohete1;
	    static TMASound snd_Cohete2;
	    static TMASound snd_Silvido;
        
        void doInit(int x,int y,float velx,float vely,float acx,float acy,int pcolor);
        
        bool doRun(void);
        void doPaint(TMABitmap&);  
        bool isValid(void) { return ib_valid; }
        void invalidate(void) { ib_valid=false; }
};

class TESC_Final:public TMAScene
{
    REGISTER_CLASS protected:

        const static int MAX_COHETES = 10;

        TGlaurungGame *miGame;        
        PMABitmap img_stars;
	    TFuegoArtificial fireworks[MAX_COHETES];
	    int ii_espera;
	    
	    void disparaCohete(void);
	    
    public:
        PUBLIC_CLASS_ID;
        
        TESC_Final();
        ~TESC_Final();
        
        bool doInit(const PMAObject params);
        void doPaint(TMABitmap&);
        bool doRun(void);  
};


#endif
