#ifndef _TESC_FINAL_CPP_
#define _TESC_FINAL_CPP_

#include <math.h>
#include "escenarios.h"
#include "../gp2x/gp2x.h"


REGISTER_CLASS_ID(TParticula);

TParticula::TParticula()
{
    doInit(0,0,0,0,0,0,0);
    ib_valid=false;
}

void TParticula::doInit(int x,int y,float velx,float vely,float acx,float acy,int pcolor)
{
    px=x; py=y;
    vx=velx; vy=vely;
    ax=acx; ay=acy;
    r=getr(pcolor);
    g=getg(pcolor);
    b=getb(pcolor);
    head=0; tail=0; elems=0;
    live=50;
    ib_valid=true;
}

bool TParticula::doRun(void)
{        
    if (live==0 && elems<1)
    {
        invalidate();
        return false;
    }    
    
    if (live>0)
    {
        if (elems==MAX_PARTICULA_PATH) tail = (tail + 1) % MAX_PARTICULA_PATH;
        else elems++;
        live--;
    }
    else 
    {
        tail = (tail + 1) % MAX_PARTICULA_PATH;
        elems--;
    }        

    int pos = head;
    head = (head + 1) % MAX_PARTICULA_PATH; 
    
    path[pos].x = (int)px;
    path[pos].y = (int)py;
    px += vx; py += vy;
    vx += ax; vy += ay;

    return isValid();
}

void TParticula::doPaint(TMABitmap& gra)
{
    int cr,cg,cb,index = head;
    
    for (int i=0;i<elems;i++)
    {
        index--;
        if (index<0) index=MAX_PARTICULA_PATH-1;
        
        int color = gra.getPixel(path[index].x,path[index].y);
        
        cr = (r - getr(color)) / elems;
        cg = (g - getg(color)) / elems;
        cb = (b - getb(color)) / elems;
                        
        cr = getr(color) + cr*(elems - i);
        cg = getg(color) + cg*(elems - i);
        cb = getb(color) + cb*(elems - i);
        
        gra.setPixel(path[index].x,path[index].y,makecol(cr,cg,cb));
        
    }
}

// ------- Fuego Artificial
//
REGISTER_CLASS_ID(TFuegoArtificial);

TMASound TFuegoArtificial::snd_Cohete1;
TMASound TFuegoArtificial::snd_Cohete2;
TMASound TFuegoArtificial::snd_Silvido;

float TFuegoArtificial::SIN[1024];
float TFuegoArtificial::COS[1024];
int   TFuegoArtificial::COLORES[10];

void TFuegoArtificial::doInit(int x,int y,float velx,float vely,float acx,float acy,int pcolor)
{
    ib_subiendo=true;
    ib_valid=true;
    particulas[0].doInit(x,y,velx,vely,acx,acy,pcolor);
    particulas[0].live=1000;
    
    if (TMAGame::isSoundAvailable()) 
    {
        if (TSpriteGlaurung::miRND.nextInt(10)>3) snd_Silvido.play();
    }
}

bool TFuegoArtificial::doRun(void)
{
    if (!isValid()) return false;
    
    if (ib_subiendo)
    {
        particulas[0].doRun();

        if (particulas[0].vy>0)
        {
            if (TMAGame::isSoundAvailable()) 
            {
                if (TSpriteGlaurung::miRND.nextInt(1000)>600)
                    snd_Cohete2.play(); 
                else 
                    snd_Cohete1.play();
            }
            
            ib_subiendo=false;
            int px = (int)particulas[0].px;
            int py = (int)particulas[0].py;
            particulas[0].invalidate();
            int color = COLORES[TSpriteGlaurung::miRND.nextInt(10)];
            
            for (int i=0;i<MAX_PARTICULAS;i++)
            {
                int rnd = TSpriteGlaurung::miRND.nextInt(1024);
                int rnd1 = TSpriteGlaurung::miRND.nextInt(1024);
                int live = 10+TSpriteGlaurung::miRND.nextInt(30);
                int divax = 10+TSpriteGlaurung::miRND.nextInt(90);
                int divay = 10+TSpriteGlaurung::miRND.nextInt(90);
                
                float vx = SIN[rnd % 1024];
                float vy = COS[rnd % 1024];
                if (vx==0) vx=1;
                if (vy==0) vy=-1;
                
                particulas[i].doInit((int)(px+vx*2),(int)(py+vy*2),SIN[rnd%1024],
                    COS[rnd%1024],SIN[rnd1%1024]/divax,COS[rnd1%1024]/divay,color);
                particulas[i].live=live;
            }
        }
    }
    else
    {
        bool valid=false;
        for (int i=0;i<MAX_PARTICULAS;i++)
        {
            if (particulas[i].isValid()) 
            {
                particulas[i].doRun();
                valid=true;
            }
        }
        if (!valid) invalidate();
    }
    return isValid();
}

void TFuegoArtificial::doPaint(TMABitmap& g)
{
    if (!isValid()) return;
    
    if (ib_subiendo)
    {
        particulas[0].doPaint(g);
    }
    else
    {
        for (int i=0;i<MAX_PARTICULAS;i++)
            if (particulas[i].isValid()) particulas[i].doPaint(g);
    }
}


// ------- Escenario FINAL
//
REGISTER_CLASS_ID(TESC_Final);

TESC_Final::TESC_Final()
{
    img_stars = NULL;
    miGame = (TGlaurungGame*)TMAGame::getCurrentGame();
}

TESC_Final::~TESC_Final()
{
    if (img_stars!=NULL) delete img_stars;
    TFuegoArtificial::snd_Cohete1.unload();
    TFuegoArtificial::snd_Cohete2.unload();
    TFuegoArtificial::snd_Silvido.unload();
}

bool TESC_Final::doInit(const PMAObject params)
{    
    TMAGame::getCurrentGame()->setGameFPS(32);

    ii_espera=10;

    for(int i = 0; i < 1024; i++)
    {
        double d = (3.1415926535897931 * (double)i * 2.0) / 1024.0;
        TFuegoArtificial::SIN[i] = sin(d);
        TFuegoArtificial::COS[i] = cos(d);
    }
    
    TFuegoArtificial::COLORES[0]=makecol(255, 255, 255);
    TFuegoArtificial::COLORES[1]=makecol(255, 255, 100);
    TFuegoArtificial::COLORES[2]=makecol(148, 248, 198);
    TFuegoArtificial::COLORES[3]=makecol(020, 255, 255);
    TFuegoArtificial::COLORES[4]=makecol(255, 128, 192);
    TFuegoArtificial::COLORES[5]=makecol(255, 235, 165);
    TFuegoArtificial::COLORES[6]=makecol(255, 128, 255);
    TFuegoArtificial::COLORES[7]=makecol(128, 158, 255);
    TFuegoArtificial::COLORES[8]=makecol(255, 128, 000);
    TFuegoArtificial::COLORES[9]=makecol(133, 222, 020);
    
    if (TMAGame::isSoundAvailable())
    {
        TFuegoArtificial::snd_Cohete1.load("Data/Sound/Cohete1.wav");
        TFuegoArtificial::snd_Cohete2.load("Data/Sound/Cohete2.wav");
        TFuegoArtificial::snd_Silvido.load("Data/Sound/CoheteSilvido.wav");
    }       

    img_stars = TMABitmap::loadFromFile("Data/Decorados/stars.png");
    for (int i=0;i<MAX_COHETES;i++) fireworks[i].invalidate();
	return true;
}

void TESC_Final::doPaint(TMABitmap& g)
{
	g.clear(0);
	g.draw(img_stars,0,0,false);
	
	for (int i=0;i<MAX_COHETES;i++)
	{
	   if (fireworks[i].isValid()) fireworks[i].doPaint(g);
    }
    
    for (int i=0;i<5;i++)
    {
        const char *txt = ((PMAString)miGame->iv_Textos.elementAt(20+i))->text();
        if (txt) //miGame->fontRed.drawText(g,txt,-1,250+35*i,NULL,640);
        miGame->fontRubber.drawText(g,txt,-1,250+35*i,NULL,640);
    }
}

bool TESC_Final::doRun(void)
{
    ii_espera--;
    if (ii_espera==0)
    {
        ii_espera = 1+TSpriteGlaurung::miRND.nextInt(5);
        disparaCohete(); 
    }
    
    for (int i=0;i<MAX_COHETES;i++)
	{
	   if (fireworks[i].isValid()) fireworks[i].doRun();
    }
    
	poll_joystick();
    if (joy[0].button[GB_SELECT].b)
    {
        joy[0].button[GB_SELECT].b=0;
        miGame->setScene(new TESC_Menu_Principal());
    }
            
    return true;
}                    

void TESC_Final::disparaCohete(void)
{
    for (int i=0;i<MAX_COHETES;i++)
    {
        if (!fireworks[i].isValid())
        {
            int px = 300 + TSpriteGlaurung::miRND.nextInt(40);
            float velx = 1.0f/(10+TSpriteGlaurung::miRND.nextInt(10));
            float vely = (-5.0) - TSpriteGlaurung::miRND.nextInt(5);
            float acx = 1.0f/(20+TSpriteGlaurung::miRND.nextInt(10));
            float acy = 1.0f/(10+TSpriteGlaurung::miRND.nextInt(10));
            int color = TSpriteGlaurung::miRND.nextInt(10);
            if (color>4) 
            {
                velx=-velx;
                acx=-acx;
            }                    
            fireworks[i].doInit(px,480,velx,vely,acx,acy,TFuegoArtificial::COLORES[color]);
            return;
        }
    }
}

#endif
