#ifndef _TESC_SELECCION_IDIOMA_
#define _TESC_SELECCION_IDIOMA_

#include "escenarios.h"
#include "../gp2x/gp2x.h"


REGISTER_CLASS_ID(TESC_Seleccion_Idioma);
TMAString TESC_Seleccion_Idioma::ia_himnos[5] = 
{
    "Data/Idioma/Textos/LG_SPAIN2.TXT",
    "Data/Idioma/Textos/LG_CHIQUITO.TXT",
    "Data/Idioma/Textos/LG_ENGLISH.TXT",
    "Data/Idioma/Textos/LG_FRANCAIS.TXT",
    "Data/Idioma/Textos/LG_DEUTSCH.TXT"
};
int TESC_Seleccion_Idioma::ia_cursor_pos[] = { 40,160,280,400,520};
char *TESC_Seleccion_Idioma::ia_lang_name[] = { "ESPAOL","CHIQUITISTANI","ENGLISH","FRANAIS","DEUTSCH" };


TESC_Seleccion_Idioma::TESC_Seleccion_Idioma():TMAScene()
{
    miGame = (TGlaurungGame*)TMAGame::getCurrentGame();
}

TESC_Seleccion_Idioma::~TESC_Seleccion_Idioma()
{
    if (io_Screen!=NULL)
    {
        delete io_Screen;
        io_Screen = NULL;
    }
    if (sprSeleccion!=NULL) delete sprSeleccion;
    if (masoft!=NULL) delete masoft;
    if (iv_Textos) delete iv_Textos;
}

bool TESC_Seleccion_Idioma::doInit(const PMAObject params)
{
    TSpriteGlaurung::setScreen(NULL);
    TSpriteGlaurung::setBurladero(NULL);
    
    li_alpha=0; ii_linea=0; ii_cuenta=0;

    if (!map.setMapFile("Data/Idioma.mpb"))
    {
        miGame->showFatalError("No se puede cargar archivo de mapa.");
        return false;
    }
    
    io_Screen = NULL; 
    gotoSelectLanguage();

    if (io_Screen)
    {
        masoft = TMABitmap::loadFromFile("Data/Icons/masoft.png");
        sprSeleccion = new TSpriteSeleccion(map.getImageBank(2),true,this);
        sprSeleccion->putAt(ia_cursor_pos[miGame->gi_idioma],315);
        iv_Textos = new TMAVector(MAX_SCROLL,5,false);
    }

    return (io_Screen!=NULL);
}        

bool TESC_Seleccion_Idioma::doRun(void)
{
    switch (ii_Estado)
    {
        case 0: // Seleccion de Idioma
            doRunLanguage();
            break;
            
        case 1: // Historia del Juego
            poll_joystick();
			if (joy[0].button[GB_SELECT].b)
			{
				joy[0].button[GB_SELECT].b=0;
				gotoSelectLanguage();
                return true;
			}
            doRunHistory();
            break;
    }
    
    return false;
}

void TESC_Seleccion_Idioma::doPaint(TMABitmap& buff)
{
    switch (ii_Estado)
    {
        case 0: // Seleccion de Idioma
            doPaintLanguage(buff);
            break;
            
        case 1: // Historia del Juego
            doPaintHistory(buff);
            break;
    }
};

void TESC_Seleccion_Idioma::doPaintLanguage(TMABitmap& buff)
{
    buff.clear(map.getBackgroundColor());
    map.drawScreen(buff,io_Screen);
    
    sprSeleccion->animate();
    sprSeleccion->draw(buff);
    miGame->fontRubber.drawText(buff,ia_lang_name[miGame->gi_idioma],-1,400,NULL,640);
    
    if (li_alpha<255)
    {
        buff.setAlpha(li_alpha); li_alpha+=2;
        buff.drawAlpha(masoft,70,50);
        buff.setAlpha(255);
    }
    else  buff.draw(masoft,70,50,true);
}

void TESC_Seleccion_Idioma::doPaintHistory(TMABitmap& buff)
{
    if (io_Screen!=NULL)
	{
		buff.clear(0);
		map.drawScreenGraphOperations(buff,io_Screen,TMAGraphOperation::OP_NORMAL);
		scrollText(buff);
		map.drawScreenGraphOperations(buff,io_Screen,TMAGraphOperation::OP_FRONT);
	}
}

void TESC_Seleccion_Idioma::doRunLanguage(void)
{
	poll_joystick();
    if (joy[0].stick[0].axis[0].d1 && miGame->gi_idioma>0 && !sprSeleccion->isMoving())
	{
		sprSeleccion->gi_idioma = (miGame->gi_idioma-1);
		sprSeleccion->moveTo(ia_cursor_pos[sprSeleccion->gi_idioma],sprSeleccion->position.y);
	}
	else if (joy[0].stick[0].axis[0].d2 && miGame->gi_idioma<4 && !sprSeleccion->isMoving())
	{
		sprSeleccion->gi_idioma = (miGame->gi_idioma+1);
		sprSeleccion->moveTo(ia_cursor_pos[sprSeleccion->gi_idioma],sprSeleccion->position.y);
	}
	else if ( (joy[0].button[GB_START].b) && !sprSeleccion->isMoving()) 
	{
		joy[0].button[GB_START].b=0;
		gotoShowHistory();
	}

	
}

void TESC_Seleccion_Idioma::doRunHistory(void)
{
	poll_joystick();
	if (joy[0].button[GB_START].b) 
	{
		joy[0].button[GB_START].b=0;
		gotoMainMenu();
	}
}

void TESC_Seleccion_Idioma::scrollText(TMABitmap& buff)
{
    for (int i=0;i<iv_Textos->size();i++)
    {    	
        PMAString str = (PMAString)iv_Textos->elementAt(i);
        if (str!=NULL && str->text()!=NULL) 
        {
            miGame->fontRed.drawText(buff,str->text(),-1,((i+1)*ALTURA_SCROLL) - ii_cuenta,NULL,640);
        }
    }
    
    if (ii_cuenta==ALTURA_SCROLL)
    {
    	ii_cuenta = 0;
        iv_Textos->addElement(iv_Historia.elementAt(ii_linea));
        if (iv_Textos->size()==MAX_SCROLL) iv_Textos->removeElementAt(0);
        	
    	if (ii_linea < iv_Historia.size() - 2)
    		ii_linea++;
    	else
    		ii_linea=0;				
    }
    ii_cuenta++;
}

void TESC_Seleccion_Idioma::playCountryMidi(void)
{
}

void TESC_Seleccion_Idioma::playHistoryMidi(void)
{
}

void TESC_Seleccion_Idioma::languageChanged(void)
{
    miGame->gi_idioma = sprSeleccion->gi_idioma;
    playCountryMidi();
    miGame->saveConfiguration();
}

void TESC_Seleccion_Idioma::loadHistory(void)
{
	FILE *f;
	char buff[255];
	int i,maxbuff=sizeof(buff)-1;

	iv_Historia.clear();

	f=fopen(*ia_himnos[miGame->gi_idioma],"rt");
	
	if (f!=NULL)
	{
        // Ignoramos la primera linea
		//
		fgets(buff,maxbuff,f);
        miGame->iv_Textos.clear();
        
        // Leemos textos de mensajes para el juego
		//
		for (i=0;i<MAX_GAME_TEXT;i++)
		{
            fgets(buff,maxbuff,f);
			buff[strlen(buff)-1]=0;
            miGame->iv_Textos.addElement(new TMAString(buff));
		}

        // Ignoramos linea de separacion
		//
		fgets(buff,maxbuff,f);

		// Leemos texto de Scroll en Menu
		//
		fgets(buff,maxbuff,f);
		buff[strlen(buff)-1]=0;
		TESC_Menu_Principal::gs_scroll_text=buff;
		
        // Ignoramos linea de separacion
		//
		fgets(buff,maxbuff,f);

		// Leemos opciones de juego
		//
		for (i=0;i<6;i++)
		{
			fgets(buff,maxbuff,f);
			buff[strlen(buff)-1]=0;
			TESC_Menu_Principal::gs_menu_options_text[i]=buff;
		}

		// Leemos textos de redefinicion de teclas
		//
		for (i=0;i<8;i++)
		{
			fgets(buff,maxbuff,f);
			buff[strlen(buff)-1]=0;
		}

		// Ignoramos la linea de separacin
		//
		fgets(buff,maxbuff,f);

		// Ahora leemos la historia
		//		
		while (!feof(f))
		{
			fgets(buff,maxbuff,f);
			if (strlen(buff)>0)
			{
				buff[strlen(buff)-1]=0;
				iv_Historia.addElement(new TMAString(buff));
			}
			else iv_Historia.addElement(NULL);
		}
		fclose(f);
	}
}
	    
void TESC_Seleccion_Idioma::gotoShowHistory(void)
{
    ii_Estado=-1;
	ii_linea = 0;
	ii_cuenta = ALTURA_SCROLL;
    delete io_Screen;
    io_Screen = map.getScreen(2);
	iv_Textos->clear();
	iv_Textos->fillEmpty(MAX_SCROLL-1);
	playHistoryMidi();
	loadHistory();
	ii_Estado=1;
}

void TESC_Seleccion_Idioma::gotoSelectLanguage(void)
{
    ii_Estado=-1;
	ii_cuenta = ALTURA_SCROLL;
    if (io_Screen!=NULL) delete io_Screen;
    io_Screen = map.getScreen(1);
	playCountryMidi();
	ii_Estado=0;
}


void TESC_Seleccion_Idioma::gotoMainMenu(void)
{
	ii_Estado=-1;
	
	// Cargamos los sonidos que hayan podido cambiar.
	//
    /*if (miGame->gi_idioma == TGlaurungGame::LG_CHIQUITISTANI)
    {
    	if (miGame->gi_idioma_anterior != TGlaurungGame::LG_CHIQUITISTANI)
    	{
            miGame->isnd_Muerte.load("Data/Sound/Chiquito/Muelas.wav");
            miGame->isnd_MuerteEnemigo.load("Data/Sound/Chiquito/Fuegor.wav");
    	}
    }
    else
    {
    	if (miGame->gi_idioma_anterior == TGlaurungGame::LG_CHIQUITISTANI)
    	{
            miGame->isnd_Muerte.load("Data/Sound/Guao.wav");
            miGame->isnd_MuerteEnemigo.load("Data/Sound/MuerteEnemigo.wav");
    	}
    }*/
    miGame->gi_idioma_anterior = miGame->gi_idioma;
	if (miGame->gi_idioma == TGlaurungGame::LG_CHIQUITISTANI)
    {
        miGame->isnd_Muerte.load("Data/Sound/Chiquito/Muelas.wav");
        miGame->isnd_MuerteEnemigo.load("Data/Sound/Chiquito/Fuegor.wav");
	}
	else
	{
        miGame->isnd_Muerte.load("Data/Sound/Guao.wav");
        miGame->isnd_MuerteEnemigo.load("Data/Sound/MuerteEnemigo.wav");
	}
		
	miGame->setScene(new TESC_Menu_Principal());
}

	    
#endif
