#ifndef _GLAURUNG_CPP_
#define _GLAURUNG_CPP_

#include "glaurung.h"
#include "../escenas/escenarios.h"
#include "../gp2x/gp2x.h"

// **************************************
// Definicin de mtodos de clase TMAGame
// **************************************
//
REGISTER_CLASS_ID(TGlaurungGame);

TMAString TGlaurungGame::gs_charset("ABCDEFGHIJKLMNOPQRSTUVWXYZ:.,()*0123456789 '-");
TMAString TGlaurungGame::gs_charset1("ABCDEFGHIJKLMNOPQRSTUVWXYZ:.,()*0123456789 '-?!$%&[]\"");
TMAString TGlaurungGame::gs_numericset("0123456789");

int TGlaurungGame::ga_GameKeys[8]={KEY_LEFT,KEY_RIGHT,KEY_UP,KEY_DOWN,KEY_X,KEY_Z,KEY_TAB,KEY_ESC};
int TGlaurungGame::gi_idioma=TGlaurungGame::LG_SPAIN;
int TGlaurungGame::gi_idioma_anterior=TGlaurungGame::LG_SPAIN;

// --------- IMPLEMENTACION DE DESTRUCTOR
//
TGlaurungGame::~TGlaurungGame()
{
    cleanup();
}

void TGlaurungGame::cleanup(void)
{

}

// --------- INICIALIZACION DEL JUEGO
//
bool TGlaurungGame::init(void)
{ 
    lb_init=false; 
     
    if (!TMAGame::init()) return false;
    loadConfiguration();
    setWindowTitle("Las 3 Luces de Glaurung");
    if (!setGraphicsMode(640,480,16,config_fullscreen)) return false;
    setGameFPS(32);
    
    lb_init = true;
        
    if (!glaurungMap.setMapFile("Data/glaurung.mpb"))
    {
        showFatalError("No se puede cargar archivo de mapa.");
        return false;
    }
    
    if (!glaurungMap.createBufferForFastDrawing(640,480))
    {
        showFatalError("No hay memoria para crear el BackBuffer de los mapas.");
        return false;
    }  
    
    // Inicializamos los numeros aleatorios
    //
    TSpriteGlaurung::miRND.init();
    
    // Cargamos los tipos de letras constantes en el juego
    //
    fontBlue.load("Data/Menu/FuenteBlue.png",20,30,gs_charset.length(),1,true,getRGBColor(255,0,255));
    fontBlue.setCharacters(*gs_charset);
    fontRed.load("Data/Menu/FuenteRed.png",20,30,gs_charset.length(),1,true,getRGBColor(255,0,255));
    fontRed.setCharacters(*gs_charset);
    fontMulti.load("Data/Menu/FuenteMulti.png",20,30,gs_charset.length(),1,true,getRGBColor(255,0,255));
    fontMulti.setCharacters(*gs_charset);
    fontNumeric.load("Data/Menu/FuenteNumerica.png",12,15,gs_numericset.length(),1,true,getRGBColor(255,0,255));
    fontNumeric.setCharacters(*gs_numericset);
    fontRubber.load("Data/Menu/rubber24.png",24,28,gs_charset1.length(),1,false,getRGBColor(255,0,255));
    fontRubber.setCharacters(*gs_charset1);
    
    // Cargamos los sonidos
    //
    isnd_Paso.load("Data/Sound/Paso.wav");
	isnd_Carrera.load("Data/Sound/Carrera.wav");	
    isnd_Muerte.load("Data/Sound/Guao.wav");
	isnd_MuerteEnemigo.load("Data/Sound/MuerteEnemigo.wav");
	isnd_HombreMalo.load("Data/Sound/Chiquito/HombreMalo.wav");
    isnd_CierraBurladero.load("Data/Sound/CierraBurladero.wav");	
    isnd_AbreBurladero.load("Data/Sound/AbreBurladero.wav");	
    isnd_RisaBrujo.load("Data/Sound/RisaBrujo.wav");	
    isnd_CogerLlave.load("Data/Sound/CogerLlave.wav");	
    isnd_AbrirCofre.load("Data/Sound/AbrirCofre.wav");	
    isnd_ApareceBrujoDragon.load("Data/Sound/ApareceBrujoDragon.wav");	
    isnd_DiamanteEncontrado.load("Data/Sound/DiamanteEncontrado.wav");	
    isnd_SoltarDinero.load("Data/Sound/SoltarDinero.wav");
    isnd_Cerdito.load("Data/Sound/Cerdito.wav");
    isnd_Ultratumba.load("Data/Sound/Ultratumba.wav");
    isnd_Moleston.load("Data/Sound/Moleston.wav");


    // Inicializamos los datos globales de sprites
    //
    TSpriteGlaurung::initialize();
    
    // Establecemos el escenario inicial
    //    
    setScene(new TESC_Seleccion_Idioma());
    //setScene(new TESC_Final());
    
    return true;
}


void TGlaurungGame::doRun(void)
{
	poll_joystick();
	if (joy[0].button[GB_START].b && joy[0].button[GB_CLICK].b)
	{
		joy[0].button[GB_START].b=0;
		joy[0].button[GB_CLICK].b=0;
		this->endGame();
        return;
	}
}

void TGlaurungGame::doPaint(TMABitmap& buff)
{
    buff.clear(0);
};

void TGlaurungGame::loadConfiguration(void)
{
 config_fullscreen = false;
 
 // Intentamos abrir el archivo de configuracion
 //
 FILE *f = fopen("Data/config","rb");
 
 // Si no existe, intentamos crear uno con los valores actuales.
 //
 if (!f)
 {
  saveConfiguration();
  return;
 }
 
 // Leemos los valores.
 //
 fread(&config_fullscreen,sizeof(config_fullscreen),1,f);
 fread(&TGlaurungGame::gi_idioma,sizeof(TGlaurungGame::gi_idioma),1,f);
 fread(&TGlaurungGame::gi_idioma_anterior,sizeof(TGlaurungGame::gi_idioma_anterior),1,f);
 fread(&TGlaurungGame::ga_GameKeys[0],sizeof(TGlaurungGame::ga_GameKeys),1,f);
 fclose(f);
}

void TGlaurungGame::saveConfiguration(void)
{
 // Intentamos crear el archivo de configuracion
 //
 FILE *f = fopen("Data/config","wb");
 
 // Si no podemos crearlo, desistimos
 //
 if (!f) return;
 
 // Escribimos los valores.
 //
 config_fullscreen = (lb_init)?this->isFullScreen():false;
 fwrite(&config_fullscreen,sizeof(config_fullscreen),1,f);
 fwrite(&TGlaurungGame::gi_idioma,sizeof(TGlaurungGame::gi_idioma),1,f);
 fwrite(&TGlaurungGame::gi_idioma_anterior,sizeof(TGlaurungGame::gi_idioma_anterior),1,f);
 fwrite(&TGlaurungGame::ga_GameKeys[0],sizeof(TGlaurungGame::ga_GameKeys),1,f);
 fclose(f);
}

int MainProc(int argc, char** argv)
{ 
    TGlaurungGame miGame;
    
    if (miGame.init())
    {
        miGame.run();
        return 0;
    }
    else
    {
        miGame.showAlert("No se pudo inicializar la aplicacin.");
    }
    return -1;    
}

#endif
