#ifndef _GLAURUNG_H_
#define _GLAURUNG_H_

#include "../ma_allegro/ma_allegro.h"
#include "../ma_allegro/maps/mapas.h"

class TGlaurungGame:public TMAGame
{
    REGISTER_CLASS protected:
        
    public:
        PUBLIC_CLASS_ID;
        
        // Idiomas y Juegos de Caracteres
        //
        static TMAString gs_charset;
        static TMAString gs_charset1;
        static TMAString gs_numericset;
        static const int LG_SPAIN=0;
        static const int LG_CHIQUITISTANI=1;
        static const int LG_ENGLISH=2;
        static const int LG_FRENCH=3;
        static const int LG_DEUTCH=4;
        
        // Valores de las teclas
        //
        static const int GKEY_LEFT=0;
        static const int GKEY_RIGHT=1;
        static const int GKEY_UP=2;
        static const int GKEY_DOWN=3;
        static const int GKEY_SELECT=4;
        static const int GKEY_USE=5;
        static const int GKEY_MAP=6;
        static const int GKEY_OPTIONS=7;
        static int ga_GameKeys[8];
        
        // Mapas y Tipos de Letras
        //
        static int gi_idioma,gi_idioma_anterior; 
        TMAFont fontBlue;
        TMAFont fontRed;
        TMAFont fontMulti;
        TMAFont fontNumeric;
        TMAFont fontRubber;	
        
        // Otras propiedades
        //
        TMAGameMap glaurungMap;
        TMAVector iv_Textos;
        
        // Sonidos del juego
        //
        TMASound isnd_Paso;
        TMASound isnd_Carrera;
        TMASound isnd_Muerte;
        TMASound isnd_MuerteEnemigo;
        TMASound isnd_CierraBurladero;
        TMASound isnd_AbreBurladero;
        TMASound isnd_RisaBrujo;
        TMASound isnd_CogerLlave;
        TMASound isnd_AbrirCofre;
        TMASound isnd_ApareceBrujoDragon;
        TMASound isnd_DiamanteEncontrado;
        TMASound isnd_SoltarDinero;
        TMASound isnd_Cerdito;
        TMASound isnd_HombreMalo;
        TMASound isnd_Ultratumba;
        TMASound isnd_Moleston;
        
        
        bool config_fullscreen;
        bool lb_init;
        
        // Constructor y Mtodos
        //
        ~TGlaurungGame();  
        
        bool init(void);
        void cleanup(void);
        void doRun(void);
        void doPaint(TMABitmap&);
        
        void loadConfiguration(void);
        void saveConfiguration(void);
};

#endif
