#ifndef _TSPRITEABRECOFRE_CPP_
#define _TSPRITEABRECOFRE_CPP_

#include "sprites.h"
#include "../main/glaurung.h"
#include "../escenas/escenarios.h"

REGISTER_CLASS_ID(TSpriteAbreCofre);
int TSpriteAbreCofre::ia_anim[21]={79,80,81, 90,81,80, 81,90,81, 80,81,90, 81,80,81, 90,81,80, 81,90,91};

TSpriteAbreCofre::TSpriteAbreCofre(PMAImageBank bank):TSpriteGlaurung(bank)
{
    ia_AnimSequence = ia_anim;
    ii_AnimSequenceLength=21;
	ii_Retardo=2;		
	ii_CurrentFotograma=ia_anim[0];
	velocidad=20;
	tesoro_en_cofre=0;
    
    ii_tilesx=4; ii_tilesy=6;

	// Inicialmente esta inactiva
	//
	invalidate();
    
    // Establecemos el tamao de la VIENTO
    position.width = 80;
    position.height = 120;

    // Contador de Estado a 0.
    ii_Estado=0;
}

void TSpriteAbreCofre::init(int x,int y,int tipo_tesoro,PSpriteRedham rh)
{
	position.x = x;
	position.y = y;
    tesoro_en_cofre=tipo_tesoro;
    SprMain = rh;
    miGame->isnd_AbrirCofre.play(false);
    validate();
}

bool TSpriteAbreCofre::draw(TMABitmap& g)
{
    TSpriteGlaurung::draw(g);
    return isValid();
}

void TSpriteAbreCofre::animate(void)
{
	switch (ii_EstadoAnim)
	{
	  case 0: // Animacin Andando Normal.

		if (ii_RetardoPos<ii_Retardo)
		{
			ii_RetardoPos ++;
		}
		else
		{
			ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
			ii_RetardoPos=0;
		}
		break;
	}

	TSpriteGlaurung::animate();

    if (ii_Frame==20)
    {
        showTreasure(true);
        invalidate();
    }
}

void TSpriteAbreCofre::showTreasure(bool enemigos)
{		
    PSpriteTexto sprtxt=NULL;
    PMAImageBank bank = miGame->glaurungMap.getImageBank(0);
    TESC_Juego *miJuego = (TESC_Juego*)miGame->getScene();
    
    switch (tesoro_en_cofre)
    {
        case TScreenInfo::SIN_TESORO:
            return;

        case TScreenInfo::GEMA_ROJA:

            SprMain->ii_gemas |= 1;
            miGame->isnd_DiamanteEncontrado.play(false);	         
			sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(0))->text());
            break;

        case TScreenInfo::GEMA_VERDE:

            SprMain->ii_gemas |= 4;
        	miGame->isnd_DiamanteEncontrado.play(false);        
			sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(1))->text());
            break;
       
        case TScreenInfo::GEMA_AZUL:

            SprMain->ii_gemas |= 2;
        	miGame->isnd_DiamanteEncontrado.play(false);
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(2))->text());
            break;

        case TScreenInfo::LLAVE_ROJA:

            SprMain->ii_llaves |= 0x01;
    		miGame->isnd_CogerLlave.play(false);
            sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(3))->text());
            break;
    
        case TScreenInfo::LLAVE_AZUL:

            SprMain->ii_llaves |= 0x02;
        	miGame->isnd_CogerLlave.play(false);
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(4))->text());
            break;

        case TScreenInfo::POCION_AMARILLA:

            SprMain->ib_pocion_amarilla = true;
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(5))->text());
            break;

        case TScreenInfo::POCION_VERDE:

            SprMain->ib_pocion_verde = true;
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(6))->text());
            break;
    
        case TScreenInfo::BOLSA_ORO:

            SprMain->ii_monedas++;	       
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(7))->text());
            break;

        case TScreenInfo::CAJA_FLECHAS:

            SprMain->ii_flechas+=5;	            
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(8))->text());
            break;

        case TScreenInfo::VIDA_EXTRA:

            SprMain->ii_vidas++;
        	sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(9))->text());
            break;
    
        case TScreenInfo::HECHIZO_CERDO:

            SprMain->setTransform(true);
			miGame->isnd_Cerdito.play(false);
            sprtxt=new TSpriteTexto();
			sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(10))->text());
            break;
    
        case TScreenInfo::SPIDER_ARQUERO:

            if (enemigos)
            {
            	PSpriteGlaurung a = new TSpriteArquero(bank,bank,false);
                a->putAt(position.x,position.y);
                if (!miJuego->SprRedham->isInvisible()) a->setTarget(miJuego->SprRedham);
                miJuego->addSprite(a,false);
                sprtxt=new TSpriteTexto();
				sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(11))->text());
	            
                if (TGlaurungGame::gi_idioma == TGlaurungGame::LG_CHIQUITISTANI) 
                {
                	miGame->isnd_HombreMalo.play(false);			            
                }
                else
                {
                	miGame->isnd_RisaBrujo.play(false);
                }
            }
            break;

        case TScreenInfo::BAT_LANCERO:

            if (enemigos)
            {
            	PSpriteGlaurung a;
            	if (miRND.nextInt(10)<5) a = new TSpriteLancero(bank);
            	else a = new TSpriteMurcielago(bank,miRND.nextInt(2));
                
            	a->putAt(position.x,position.y);
                if (!miJuego->SprRedham->isInvisible()) a->setTarget(miJuego->SprRedham);
                miJuego->addSprite(a,false);                
                sprtxt=new TSpriteTexto();
				sprtxt->init(2,-1,140,&miGame->fontBlue,((PMAString)miGame->iv_Textos.elementAt(11))->text());
	            
                if (TGlaurungGame::gi_idioma == TGlaurungGame::LG_CHIQUITISTANI) 
                {
                	miGame->isnd_HombreMalo.play(false);			            
                }
                else
                {
                	miGame->isnd_RisaBrujo.play(false);
                }
            }
            break;
    }

    if (sprtxt!=NULL)
    {
        if (enemigos) miJuego->addSprite(sprtxt,true);
        else delete sprtxt;
    }

    // Anotamos que hemos cogido el tesoro
    //
    tesoro_en_cofre=TScreenInfo::SIN_TESORO;
}

#endif
