#ifndef _TSPRITEBRUJODRAGON_CPP_
#define _TSPRITEBRUJODRAGON_CPP_

#include "../escenas/escenarios.h"
#include "sprites.h"

REGISTER_CLASS_ID(TSpriteBrujoDragon);

int TSpriteBrujoDragon::ia_anim_dragon[4]={50,51,52,53};
int TSpriteBrujoDragon::ia_anim_brujo[4]={54,55,56,55};
int TSpriteBrujoDragon::ia_anim_aparicion[9]={79,80,81, 90,81,80, 81,90,91};
    	
TSpriteBrujoDragon::TSpriteBrujoDragon(PMAImageBank bank,PSpriteRedham r,bool brujo):TSpriteGlaurung(bank)
{
    ib_brujo = brujo;
    setAnimSequence(ia_anim_aparicion,9);
	ii_Retardo=4;
	ii_tilesy=4;
	ii_tilesx=(ib_brujo)?3:5;
	position.width = (ib_brujo)?60:100;
	position.height = 80;
	il_ciclos=0;
	
	io_flecha = new TSpriteFlecha(bank,(!ib_brujo)?TDRAGON:TBRUJO);
	io_flecha->invalidate();
	
    redham = r;
}
    
TSpriteBrujoDragon::~TSpriteBrujoDragon()
{
    if (io_flecha!=NULL) delete io_flecha;
}

int TSpriteBrujoDragon::getHotspotX(void)
{
    if (ib_flip_x)
    {
        return ((ib_brujo)?(position.x+40):(position.x+80))  / _TileAX;
    }
    return (position.x+10) / _TileAX;
}

int TSpriteBrujoDragon::getHotspotY(void)
{
    return (position.y + position.height - 1) / _TileAY;
}
	

void TSpriteBrujoDragon::move(void)
{
    // Calculamos el HOTSPOT del Sprite, para hacer los calculos
	// de detecciones en funcin de ese punto. 
	// Consideramos ese punto el punto inferior izquierdo.
	//
	int px,py;

	py = getHotspotY();
    px = getHotspotX();

    // Establecemos la posicin derecha o izquierda en funcion de hacia
    // donde este el personaje redham.
    //
    if (redham->position.x > position.x && ib_flip_x) setFlipX(false);
    if (redham->position.x < position.x && !ib_flip_x) setFlipX(true);

    // Ajustamos primero la coordenada Y
    //
    if (position.y < redham->position.y && !isDown(px,py))
    {
        if (position.y<490-position.height) position.y += _VELY;
    }
    else if (position.y > redham->position.y && !isTop(px,py))
    {
        if (position.y>40) position.y -= _VELY;
    }
    // Ahora ajustamos la coordenada X
    //
    else if (position.x < redham->position.x && canWalkRight(px,py))
    {
        if (position.x < (640 - position.width)) position.x += _VELX;
    }
    else if (position.x > redham->position.x && canWalkLeft(px,py))
    {
        if (position.x>20) position.x -= _VELX;
    }

    il_ciclos ++;
    if (il_ciclos>100) il_ciclos=0;
    
    if (il_ciclos == 0 && (!io_flecha->isValid()))
    {
        // Si el el brujo
        //
        if (ib_brujo)
        {
            if (!ib_flip_x)
                io_flecha->init(position.x+20,position.y-20,ib_flip_x,10);
            else
                io_flecha->init(position.x-20,position.y-20,ib_flip_x,10);        
        }
        else
        {
            if (!ib_flip_x)
                io_flecha->init(position.x+60,position.y+15,ib_flip_x,10);
            else
                io_flecha->init(position.x-20,position.y+15,ib_flip_x,10);
        }
    
        ((TESC_Juego*)miGame->getScene())->addSprite(io_flecha,false);
    }
}

void TSpriteBrujoDragon::animate(void)
{        
   	switch (ii_EstadoAnim)
	{
	  case 0: // Animacin Andando Normal.

		if (ii_RetardoPos<ii_Retardo)
		{
			ii_RetardoPos ++;
		}
		else
		{
			ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
			ii_RetardoPos=0;
		}

		break;
	}
	
   	// Si el personaje esta muriendo, no hacemos nada..
    //
    if (ib_muriendo)
    {
    	kill();
        TSpriteGlaurung::animate();
        return;
    }
	
    if (ia_AnimSequence != ia_anim_aparicion) move();

	TSpriteGlaurung::animate();

    if (ia_AnimSequence==ia_anim_aparicion)
    {
        if (ii_Frame==8) setAnimSequence((ib_brujo)?ia_anim_brujo:ia_anim_dragon,4);
    }
}	

bool TSpriteBrujoDragon::collisionsWith(TSpriteGlaurung& spr)
{
    if (ia_AnimSequence==ia_anim_aparicion) return false;
    return TSpriteGlaurung::collisionsWith(spr);
}

int *TSpriteBrujoDragon::getKillSequence(int& length)
{
    length = 9;
	return ia_anim_aparicion;
}

    
#endif
