#ifndef _TSPRITEBURLADERO_CPP_
#define _TSPRITEBURLADERO_CPP_

#include "../main/glaurung.h"
#include "sprites.h"

// ------------ TSpriteBurladero
//
REGISTER_CLASS_ID(TSpriteBurladero);
int TSpriteBurladero::ia_anim[15]={65,66,67,68,69,70,71,72,71,70,69,68,67,66,65};

TSpriteBurladero::TSpriteBurladero(PMAImageBank bank):TSpriteGlaurung(bank)
{	
    setAnimSequence(ia_anim,15);
	ii_Retardo=4;
	ii_Estado=0;
    invalidate();
}

void TSpriteBurladero::open(void)
{
    ii_Frame=8;
    ii_EstadoAnim=1;
    ii_Estado=0;
}
    

void TSpriteBurladero::animate(void)
{
    switch (ii_EstadoAnim)
    {
    case 0:

        if (ii_Frame==0)
        {
            miGame->isnd_AbreBurladero.play(false);
        }

        if (ii_Frame==8)
        {
            miGame->isnd_CierraBurladero.play(false);
        }

	    if (ii_RetardoPos<ii_Retardo)
	    {
		    ii_RetardoPos ++;
	    }
	    else
	    {
		    ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
		    ii_RetardoPos=0;
	    }
        
        if (ii_Frame==7 || ii_Frame==14)
        {
            ii_EstadoAnim=1;
            ii_Estado=0;
        }    
        
        break;

    case 1:
        ii_Estado++;
        if (ii_Estado>50)
        {
            ii_EstadoAnim=0;
        }
        break;
    }

	TSpriteGlaurung::animate();    
}


#endif
