#ifndef _TSPRITEFLECHA_CPP_
#define _TSPRITEFLECHA_CPP_

#include "sprites.h"

REGISTER_CLASS_ID(TSpriteFlecha);

int TSpriteFlecha::ia_anim_flecha[3]={21,22,23};
int TSpriteFlecha::ia_anim_fuego[3]={104,105,106};
int TSpriteFlecha::ia_anim_dragon[8]={57,58,59,60,61,62,63,64};
int TSpriteFlecha::ia_anim_brujo[10]={73,74,75,76,77,78,77,76,75,74};

TSpriteFlecha::TSpriteFlecha(PMAImageBank bank,int tipo):TSpriteGlaurung(bank)
{
    ii_Retardo = 2;
	ii_velocidad=20;
	
	switch(tipo)
	{
        case TFLECHA:
            setAnimSequence(ia_anim_flecha,3);
        	ii_tilesy=1; ii_tilesx=3;
        	position.width = FLECHA_AX;
	        position.height = FLECHA_AY;
        	break;
        	
        case TSPIDER:
            setAnimSequence(ia_anim_fuego,3);
        	ii_tilesy=1; ii_tilesx=3;
        	position.width = FLECHA_AX;
	        position.height = FLECHA_AY;
        	break;
        	
        case TDRAGON:
            setAnimSequence(ia_anim_dragon,8);
        	ii_tilesy=2; ii_tilesx=4;
        	position.width = 80;
	        position.height = 40;
            break;

        case TBRUJO:
            setAnimSequence(ia_anim_brujo,10);
        	ii_tilesy=3; ii_tilesx=4;
        	position.width = 80;
	        position.height = 120;
        	break;
    }
        	
	invalidate();
	putAt(-10,-10);
}
    
void TSpriteFlecha::init(int x,int y,bool flip,int vel)
{
	putAt(x,y);
	ii_velocidad = vel;
	setFlipX(flip);
	validate();	
    animate();	
}

bool TSpriteFlecha::draw(TMABitmap& g)
{
    int px,py;
    if (!isValid()) return false;

    // Dibujamos el Sprite
    //
    TSpriteGlaurung::draw(g);
    
    // Verificamos si es valido.
    //
    px = getHotspotX();
    py = getHotspotY();
    
    if (ib_flip_x)
	{
        if (!(position.x > -position.width && (io_Screen == NULL || io_Screen->getMask(px,py)!=1)))
        {
            invalidate();
        }
	}
    else
    {
	    if (!(position.x<640 && (io_Screen == NULL || io_Screen->getMask(px,py)!=1)))
        {
            invalidate();
        }
    }
    
    return isValid();
}

void TSpriteFlecha::animate(void)
{
	switch (ii_EstadoAnim)
	{
	  case 0: 

		if (ii_RetardoPos<ii_Retardo)
		{
			ii_RetardoPos ++;
		}
		else
		{
			ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
			ii_RetardoPos=0;
		}

		break;
	}

	if (isValid())
	{
		if (ib_flip_x) position.x -= ii_velocidad;
		else position.x += ii_velocidad;
	}

	TSpriteGlaurung::animate();
}

int TSpriteFlecha::getHotspotX(void)
{
    if (ib_flip_x)
	{
        return position.x / _TileAX;
	}    
    return (position.x + position.width - 2) / _TileAX;
}

int TSpriteFlecha::getHotspotY(void)
{
    return (position.y + (position.height / 2)) / _TileAY;
}

bool TSpriteFlecha::isCollisioningWith(TMASprite& s)
{
    TMARectangle R1;
	if (ia_AnimSequence==ia_anim_brujo)
	{
        R1.x = position.x;
        R1.y = position.y + 40;
        R1.width = position.width;
        R1.height = 40;
        return R1.intersects(s.position);
    }
	else 
	{
        R1.x = position.x+10;
        R1.y = position.y;
        R1.width = position.width-20;
        R1.height = 20;
        return R1.intersects(s.position);
    }
}

#endif
