#ifndef _TSPRITEMAGMA_CPP_
#define _TSPRITEMAGMA_CPP_

#include "sprites.h"
#include "../escenas/escenarios.h"

REGISTER_CLASS_ID(TSpriteMagma);
const int TSpriteMagma::ia_anim[5]={92,93,94,95,-1};
    	
#define EST_CRECIENDO   0
#define EST_REPOSANDO   1
    	
TSpriteMagma::TSpriteMagma(PMAImageBank bank):TSpriteGlaurung(bank)
{
    setAnimSequence(ia_anim,5);
    ii_Retardo=2+miRND.nextInt(4);
	ii_tilesy=1;
	ii_tilesx=4;
	position.width = 80;
	position.height = 20;
	ii_Estado = EST_REPOSANDO;
	ii_Salto = 5+miRND.nextInt(10);
	ii_CurrentFotograma = -1;
}

void TSpriteMagma::animate(void)
{
    switch (ii_Estado)
    {
        case EST_CRECIENDO:

            if (ii_RetardoPos<ii_Retardo)
            {
            	ii_RetardoPos ++;
            }
            else
            {
            	ii_Frame = (ii_Frame<ii_AnimSequenceLength - 1)?(ii_Frame+1):0;
            	ii_RetardoPos=0;
            }   
            TMASprite::animate();
            
            if (ii_CurrentFotograma==-1)
            {
                ii_Estado = EST_REPOSANDO;
                ii_Salto = 10+miRND.nextInt(10);
            }
            break;
            
        case EST_REPOSANDO:
            
            ii_Salto--;
            if (ii_Salto==0)
            {
                ii_Estado = EST_CRECIENDO;
                position.x = 80 + miRND.nextInt(460);
            }
            break;
    }
}

bool TSpriteMagma::draw(TMABitmap& g)
{
    if (ii_CurrentFotograma>=0)
    {
        g.drawSprite(io_images->getBitmap(ii_CurrentFotograma),position.x,position.y,ib_flip_x,ib_flip_y);
    }
    return true;
}

bool TSpriteMagma::isHot(void)
{
    return (ii_Estado==EST_CRECIENDO && ii_CurrentFotograma>=0);
}

#endif
