#ifndef _TSPRITEMURCIELAGO_CPP_
#define _TSPRITEMURCIELAGO_CPP_

#include "sprites.h"

REGISTER_CLASS_ID(TSpriteMurcielago);

int TSpriteMurcielago::ia_anim0[6]={34,35,36,37,36,35};
int TSpriteMurcielago::ia_anim1[6]={38,39,40,41,40,38};


TSpriteMurcielago::TSpriteMurcielago(PMAImageBank bank,int tipo):TSpriteGlaurung(bank)
{
    setAnimSequence((tipo==0)?ia_anim0:ia_anim1,6);
	ii_Retardo=2;
	ii_tilesy=2;
	ii_tilesx=4;
	ii_vx = 2;
    ii_vy = 2;
	position.width = _MURCIELAGO_AX;
	position.height = _MURCIELAGO_AY;
			
	// Obtenemos un estado aleatorio para comenzar a movernos.
	//
	ii_Estado=miRND.nextInt(8);

}
    
int TSpriteMurcielago::getHotspotX(void)
{
    return (position.x + 10) / _TileAX;
}

int TSpriteMurcielago::getHotspotY(void)
{
    return (position.y + position.height - 1) / _TileAY;
}
	

void TSpriteMurcielago::animate(void)
{
	switch (ii_EstadoAnim)
	{
	  case 0: 

		if (ii_RetardoPos<ii_Retardo)
		{
			ii_RetardoPos ++;
		}
		else
		{
			ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
			ii_RetardoPos=0;
		}

		break;
	}

	// Si el personaje esta muriendo, no hacemos nada..
    //
    if (ib_muriendo)
    {
    	kill();
        TSpriteGlaurung::animate();
        return;
    }
    
    int px,py;
    px = getHotspotX();
    py = getHotspotY();

    switch (ii_Estado)
	{
    	case 0:	// Bajar mientras sea posible.
    		if (py<22 && !isDown(px,py)) position.y += 2*ii_vy;
    		else ii_Estado++;
    		break;
    		
    	case 1: // Sube volando a la derecha.
    		if (px<28 && py>3 && canWalkRight(px,py) && !isTop(px,py))
    		{
    			position.x += ii_vx;
    			position.y -= ii_vy;
    		}
    		else ii_Estado++;
    		break;
    		
    	case 2: // Moverse en horizontal hasta la izquierda
    		if (px>2 && canWalkLeft(px,py)) position.x -= 2*ii_vx;
    		else ii_Estado++;
    		break;
    	
    	case 3: // Bajar volando a la derecha
    		if (px<28 && py<22 && canWalkRight(px,py) && !isDown(px,py))
    		{
    			position.x += ii_vx;
    			position.y += ii_vy;
    		}
    		else ii_Estado++;
    		break;
    		
    	case 4: // Subir en horizontal
    		if (py>3 && !isTop(px,py)) position.y -= 2*ii_vy;
    		else ii_Estado++;
    		break;
    		
    	case 5: // Bajar volando a la izquierda
    		if (px>2 && py<22 && canWalkLeft(px,py) && !isDown(px,py))
    		{
    			position.x -= ii_vx;
    			position.y += ii_vy;
    		}
    		else ii_Estado++;
    		break;
    	
    	case 6: // Moverse en horizontal a la derecha
    		if (px<28 && canWalkRight(px,py)) position.x += 2*ii_vx;
    		else ii_Estado++;
    		break;
    		
    	case 7: // Subir volando a la izquierda
    		if (px>2 && py>3 && canWalkLeft(px,py) && !isTop(px,py))
    		{
    			position.x -= ii_vx;
    			position.y -= ii_vy;
    		}
    		else ii_Estado=0; // Volvemos al estado inicial
    		break;	    		
	}
	    
	TSpriteGlaurung::animate();
}
    
#endif
