#ifndef _TSPRITETEMPORIZADOR_CPP_
#define _TSPRITETEMPORIZADOR_CPP_

#include "sprites.h"

REGISTER_CLASS_ID(TSpriteTemporizador);

TSpriteTemporizador::TSpriteTemporizador(PMAImageBank bank):TSpriteGlaurung(bank)
{
    sprOver = NULL;
	io_font=NULL;
	ii_id = 0;
    ii_time=0;
	il_basetime=0;
	ib_show_time = true;
	setAnimSequence(NULL,0);
	invalidate();
	position.x=0;position.y=0;
}


void TSpriteTemporizador::init(PSpriteGlaurung over,int time,PMAFont font,int id)
{
    sprOver = over;
    ii_id = id;
    io_font = font;
    il_basetime = TMAGame::getCPUTime();
    ii_time = time;
    validate();
}

void TSpriteTemporizador::restore(PSpriteGlaurung over,PMAFont font)
{
    sprOver = over;
    io_font = font;
    il_basetime = TMAGame::getCPUTime();
    validate();
}

void TSpriteTemporizador::showTime(bool show)
{
    ib_show_time = show;
}

bool TSpriteTemporizador::draw(TMABitmap& g)
{
    char txt_sec[10];
    
    // Calculamos el numero de segundos transcurridos.
    //
    long ll_sec = ii_time - ( (TMAGame::getCPUTime() - il_basetime) / 1000);
    
    if (ia_AnimSequence!=NULL) TSpriteGlaurung::draw(g);
    
    if (ll_sec>=0)
    {
    	// Dibujamos el tiempo que queda
        //
        if (ib_show_time)
        {
        	sprintf(txt_sec,"%i",ll_sec);
            if (sprOver!=NULL)
            {
                TMARectangle& r = sprOver->position;
                io_font->drawText(g,txt_sec,
            			r.x + (r.width - io_font->getTextWidth(txt_sec))/2,
        				r.y - io_font->getTextHeight() - 8,NULL,0);
            }
        }
    }
    else
    {
        invalidate();
        return false;
    }
    
    return true;
}

int TSpriteTemporizador::getHotspotX(void) 
    { return (position.x + (position.width /2)) / _TileAX; }

int TSpriteTemporizador::getHotspotY(void)
    { return (position.y + position.height) / _TileAY; }

void TSpriteTemporizador::writeToFile(FILE* f)
{
    int ltime = ii_time - ( (TMAGame::getCPUTime() - il_basetime) / 1000);
    fwrite(&ii_id,sizeof(ii_id),1,f);
    fwrite(&ltime,sizeof(ltime),1,f);
    fwrite(&ib_valido,sizeof(ib_valido),1,f);
    fwrite(&position,sizeof(position),1,f);
}

void TSpriteTemporizador::readFromFile(FILE* f)
{
    fread(&ii_id,sizeof(ii_id),1,f);
    fread(&ii_time,sizeof(ii_time),1,f);    
    fread(&ib_valido,sizeof(ib_valido),1,f);
    fread(&position,sizeof(position),1,f);
    il_basetime = TMAGame::getCPUTime();    
}

// --------------- TSpriteTexto

REGISTER_CLASS_ID(TSpriteTexto);

TSpriteTexto::TSpriteTexto():TSpriteTemporizador(NULL)
{
    showTime(false);
}

void TSpriteTexto::init(int time,int x,int y,PMAFont font,const char *texto)
{
    TSpriteTemporizador::init(NULL,time,font,0);
	text=texto;
	position.x = x;
	position.y = y;
}

bool TSpriteTexto::draw(TMABitmap& g)
{
	io_font->drawText(g,*text,position.x,position.y,NULL,640);
	return TSpriteTemporizador::draw(g);
}

// --------------- TSpriteBolsaDinero

REGISTER_CLASS_ID(TSpriteBolsaDinero);
int TSpriteBolsaDinero::ia_anim[1]={6};

TSpriteBolsaDinero::TSpriteBolsaDinero(PMAImageBank bank):TSpriteTemporizador(bank)
{
    // Creamos el array que tendr la secuencia de animacin del arquero.
    //
    ia_AnimSequence = ia_anim;
    ii_AnimSequenceLength=1;
    ii_Retardo=20;
    
    ii_CurrentFotograma=ia_AnimSequence[0];
    ii_tilesx=2; ii_tilesy=2;
    
    // Inicialmente esta inactiva
    //
    position.x = -10;
    position.y = -10;
    
    // Establecemos el tamao de la bolsa de dinero
    position.width = 40;
    position.height = 40;
}

void TSpriteBolsaDinero::init(int time,int x,int y,PMAFont font)
{
    TSpriteTemporizador::init(this,time,font,0);
	position.x = x;
	position.y = y;
}

void TSpriteBolsaDinero::animate(void)
{
    switch (ii_EstadoAnim)
    {
    case 0: 
    
        if (ii_RetardoPos<ii_Retardo)
        {
        	ii_RetardoPos ++;
        }
        else
        {
        	ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
        	ii_RetardoPos=0;
        }
        
        break;
    }
    
    TSpriteTemporizador::animate();
}

#endif
