-- Fichero de configuracion para Phantomas PC
-- Los valores que aparecen a continuacion son los valores por defecto, puedes
-- cambiarlos aqui o dejarlos y cambiarlos de forma grafica ejecutando el juego
-- por primera vez o pasando el parametro setup al programa.

-- resolution tiene la resolucion del juego, siendo esta:
-- 0: Resolucion por defecto, 640 x 480
-- 1: 800 x 600
-- 2: 1024 x 768
-- Date cuenta que la resolucion nativa del juego es 640 x 480, con otra resolucion
-- los graficos seran escalados, con lo que quizas NO se vea mejor, esto es itil
-- para algunos sistemas unix que no pueden cambiar de resolucion en el framebuffer,
-- para poder ejecutar el juego a pantalla completa. Ejemplo: si tienes el framebuffer
-- con una resolucion de 800 x 600 deja estos valores asi, pon stretch a 1 y stretchx
-- a 800 y stretchy a 600.
resolution=0
xres=640
yres=480

-- fullscreen es cierta (distinto de 0) si quieres ejecutar el programa a
-- pantalla completa. Ponlo a 0 para ejecutar el programa en una ventana.
fullscreen=1

-- stretch es cierto si quieres escalar el programa a otra resolucion
-- (se te pedira que introduzcas la resolucion a la que escalar).
stretch=0

-- Estas 2 variables guardan el valor al que escalar el juego.
stretchx=640
stretchy=480

-- enable_sound es cierta si quieres utilizar la tarjeta de sonido.
-- ponlo a 0 en caso de que tengas problemas iniciando el sonido.
enable_sound=1

-- sfx es cierta si quieres que haya efectos de sonido. 
-- Date cuenta que esta variable no se tendra en cuenta si enable_sound=0
sfx=1

-- music es cierta si quieres disfrutar de la musica del juego
-- Date cuenta que esta variable no se tendra en cuenta si enable_sound=0
music=1

-- sfxvol tiene el volumen de los efectos de sonido (de 0 a 255).
-- Date cuenta que esta variable no se tendra en cuenta si enable_sound=0
sfxvol=255

surround=1
-- musicvol tiene el volumen de la mysica (de 0 a 255).
-- Date cuenta que esta variable no se tendra en cuenta si enable_sound=0
musicvol=255

-- datadir tiene el directorio donde se encuentran los datos del juego.
-- en sistemas unix por defecto esta en /usr/local/games/phantomaspc/data
-- en windows tiene la ruta relativa al directorio donde hayas instalado
-- el juego\data
datadir="data/"

prefix="/usr/local/share/games/PhantomasPC/"

-- control_type tiene el tipo de control que usara el juego, 0 para teclado,
-- 1 para joystick digital, 2 para joystick analogico.
controltype=0


function setup_main_menu()
resaux={};
ctypeaux={};
XINC=50;
YINC=50;
	ctypeaux[0]=translate("Keyboard");
	ctypeaux[1]=translate("Joystick");
	resaux[0]=translate("640x480");
	resaux[1]=translate("800x600");
	resaux[2]=translate("1024x768");
	set_mouse_range(0,0,640,480);

	while(1) do
		alfont_set_font_size(f, 25);
		clear_to_color(virt,makecol(0,0,0));
		draw_stars();
		
		alfont_textout_aa(virt,f,translate("Graphics"),321-230+XINC,137-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Graphics"),320-230+XINC,139-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Graphics"),322-230+XINC,139-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Graphics"),321-230+XINC,141-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Graphics"),321-230+XINC,139-50-YINC,makecol(250,250,250));
		
		alfont_textout_aa(virt,f,translate("Sound"),321-230+XINC,302-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Sound"),321-230+XINC,298-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Sound"),320-230+XINC,300-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Sound"),322-230+XINC,300-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Sound"),321-230+XINC,300-YINC,makecol(250,250,250));

		alfont_textout_aa(virt,f,translate("Control"),291+XINC,141-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Control"),291+XINC,137-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Control"),290+XINC,139-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Control"),292+XINC,139-50-YINC,makecol(100,100,100));
		alfont_textout_aa(virt,f,translate("Control"),291+XINC,139-50-YINC,makecol(250,250,250));
		
		alfont_textout_aa(virt,f1,translate("Enable sounds"),320-200+XINC,350-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Enable sfx"),320-200+XINC,375-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Enable music"),320-200+XINC,400-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Surround"),320-200+XINC,425-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("SFX volume: ")..sfxvol,320-200+XINC,450-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Music volume: ")..musicvol,320-200+XINC,475-YINC,makecol(250,250,250));
		
		alfont_textout_aa(virt,f1,translate("Control type: ")..ctypeaux[controltype],320+10+XINC,140-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("High jump: ").."W",320+10+XINC,140+25-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Long jump: ").."S",320+10+XINC,140+50-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Left: ").."A",320+10+XINC,140+75-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Right: ").."D",320+10+XINC,140+100-YINC,makecol(250,250,250));
		
		alfont_textout_aa(virt,f1,translate("Fullscreen"),320-200+XINC,140-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Stretch"),320-200+XINC,140+25-YINC,makecol(250,250,250));
		alfont_textout_aa(virt,f1,translate("Resolution: ")..resaux[resolution],320-200+XINC,190-YINC,makecol(250,250,250));
		alfont_textprintf_aa_ex(virt,f1,320-200+XINC,190+25-YINC,makecol(250,250,250),-1,(translate("X Stretch: ")..stretchx));
		alfont_textprintf_aa_ex(virt,f1,320-200+XINC,190+50-YINC,makecol(250,250,250),-1,(translate("Y Stretch: ")..stretchy));
		
		if fullscreen==1 then
			draw_sprite(virt,border[8],320-230+XINC,140-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,140-YINC);
		end
		
		if stretch==1 then
			draw_sprite(virt,border[8],320-230+XINC,140+25-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,140+25-YINC);
		end
		
		if enable_sound==1 then
			draw_sprite(virt,border[8],320-230+XINC,350-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,350-YINC);
		end
		
		if sfx==1 then
			draw_sprite(virt,border[8],320-230+XINC,350+25-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,350+25-YINC);
		end
		if music==1 then
			draw_sprite(virt,border[8],320-230+XINC,350+50-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,350+50-YINC);
		end
		if surround==1 then
			draw_sprite(virt,border[8],320-230+XINC,350+75-YINC);
		else
			draw_sprite(virt,border[7],320-230+XINC,350+75-YINC);
		end

		
		draw_trans_sprite(virt,bt_ok,320+10+XINC,370-YINC);
		--draw_trans_sprite(virt,bt_cancel,320+10+XINC,370+50-YINC);
		
		
		draw_sprite(virt,border[9],320-239+XINC,190-YINC);
		draw_sprite(virt,border[10],320-221+XINC,190-YINC);
		draw_sprite(virt,border[9],320-239+XINC,190+25-YINC);
		draw_sprite(virt,border[10],320-221+XINC,190+25-YINC);
		draw_sprite(virt,border[9],320-239+XINC,190+50-YINC);
		draw_sprite(virt,border[10],320-221+XINC,190+50-YINC);
		
-- 		draw_sprite(virt,border[9],320-239+XINC,350-YINC);
-- 		draw_sprite(virt,border[10],320-221+XINC,350-YINC);
		draw_sprite(virt,border[9],320-239+XINC,350+100-YINC);
		draw_sprite(virt,border[10],320-221+XINC,350+100-YINC);
		draw_sprite(virt,border[9],320-239+XINC,350+125-YINC);
		draw_sprite(virt,border[10],320-221+XINC,350+125-YINC);
	
		draw_trans_sprite(virt,border[9],290+XINC,140-YINC);
		draw_trans_sprite(virt,border[10],290+18+XINC,140-YINC);
		draw_trans_sprite(virt,border[9],290+XINC,165-YINC);
		draw_trans_sprite(virt,border[10],290+18+XINC,165-YINC);
		draw_trans_sprite(virt,border[9],290+XINC,190-YINC);
		draw_trans_sprite(virt,border[10],290+18+XINC,190-YINC);
		draw_trans_sprite(virt,border[9],290+XINC,190+25-YINC);
		draw_trans_sprite(virt,border[10],290+18+XINC,190+25-YINC);
		draw_trans_sprite(virt,border[9],290+XINC,190+50-YINC);
		draw_trans_sprite(virt,border[10],290+18+XINC,190+50-YINC);
		
		if ppc(bt_ok,320+10+XINC,370-YINC,cursor,xm,ym)~=0 then
			draw_sprite(virt,bt_ok,320+10+XINC,370-YINC);
			if get_mouse_b()==1 then
				break;
			end
		end

		if ppc(border[7],320-230+XINC,425-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if surround==0 and done==0 then 
					done=1;
					surround=1;
				end
				if surround==1 and done==0 then 
					done=1;
					surround=0;
				end
			end
		end
		
		if ppc(border[7],320-230+XINC,400-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if music==0 and done==0 then 
					done=1;
					music=1;
				end
				if music==1 and done==0 then 
					done=1;
					music=0;
				end
			end
		end
		
		if ppc(border[7],320-230+XINC,375-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if sfx==0 and done==0 then 
					done=1;
					sfx=1;
				end
				if sfx==1 and done==0 then 
					done=1;
					sfx=0;
				end
			end
		end
		
		if ppc(border[7],320-230+XINC,350-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if enable_sound==0 and done==0 then 
					done=1;
					enable_sound=1;
				end
				if enable_sound==1 and done==0 then 
					done=1;
					enable_sound=0;
				end
			end
		end
		
		if ppc(border[7],320-230+XINC,140-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if fullscreen==0 and done==0 then 
					done=1;
					fullscreen=1;
				end
				if fullscreen==1 and done==0 then 
					done=1;
					fullscreen=0;
				end
			end
		end

		if ppc(border[7],320-230+XINC,140+25-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				done=0;
				if stretch==0 and done==0 then 
					done=1;
					stretch=1;
				end
				if stretch==1 and done==0 then 
					done=1;
					stretch=0;
				end
			end
		end

		if ppc(border[9],320-239+XINC,350+100-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				sfxvol=sfxvol-10;
			end
			if get_mouse_b()==2 then
				sfxvol=sfxvol-1;
			end
			if sfxvol<0 then sfxvol=255;end
		end
		
		if ppc(border[9],320-239+XINC,350+125-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				musicvol=musicvol-10;
			end
			if get_mouse_b()==2 then
				musicvol=musicvol-1;
			end
			if musicvol<0 then musicvol=255;end
		end
		
		if ppc(border[10],320-221+XINC,350+100-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				sfxvol=sfxvol+10;
			end
			if get_mouse_b()==2 then
				sfxvol=sfxvol+1;
			end
			if sfxvol>255 then sfxvol=0;end
		end
		
		if ppc(border[10],320-221+XINC,350+125-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				musicvol=musicvol+10
			end
			if get_mouse_b()==2 then
				musicvol=musicvol+1;
			end
			if musicvol>255 then musicvol=0;end
		end
		
				
		if ppc(border[9],320-239+XINC,190-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				resolution=resolution-1;
				if resolution<0 then resolution=2;end
			end
		end
		
		if ppc(border[10],320-221+XINC,190-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				resolution=resolution+1;
				if resolution>2 then resolution=0;end
			end
		end
		
		if ppc(border[9],320-239+XINC,190+25-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				stretchx=stretchx-10;
				if stretchx<0 then stretchx=0;end
			end
		end
		
		if ppc(border[10],320-221+XINC,190+25-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				stretchx=stretchx+10;
			end
		end
		
		if ppc(border[9],320-239+XINC,190+50-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				stretchy=stretchy-10;
				if stretchy<0 then stretchy=0;end
			end
		end
		
		if ppc(border[10],320-221+XINC,190+50-YINC,border[0],xm,ym)~=0 then
			if get_mouse_b()==1 then
				stretchy=stretchy+10;
			end
		end
		
		if resolution==0 then
			xres=640;
			yres=480;
		end
		if resolution==1 then
			xres=800;
			yres=600;
		end
		if resolution==2 then
			xres=1024;
			yres=768;
		end
		xm=get_mouse_x();
		ym=get_mouse_y();
		draw_sprite(virt,cursor,xm,ym);
		blit(virt);
	end
end


function draw_stars()
	for i=1,30 do
		putpixel(virt,star[i].x,star[i].y,makecol(150,150,150));
		putpixel(virt,star1[i].x,star1[i].y,makecol(200,200,200));
		putpixel(virt,star2[i].x,star2[i].y,makecol(250,250,250));
		star[i].y=star[i].y+2;
		star1[i].y=star1[i].y+4;
		star2[i].y=star2[i].y+6;
		if star[i].y>=480 then
			star[i].y=0;
		end
		if star1[i].y>=480 then
			star1[i].y=0;
		end
		if star2[i].y>=480 then
			star2[i].y=0;
		end
	end
end


function draw_border(x1,y1,x2,y2)
	draw_sprite(virt,border[1],x1,y1);
	draw_sprite(virt,border[3],x2,y1);
	draw_sprite(virt,border[6],x1,y2);
	draw_sprite(virt,border[5],x2,y2);
	for i=x1+8,x2-8,8 do
		draw_sprite(virt,border[2],i,y1);
		draw_sprite(virt,border[2],i,y2);
	end
	for i=y1+8,y2-8,8 do
		draw_sprite(virt,border[4],x1,i);
		draw_sprite(virt,border[4],x2,i);
	end
	drawing_mode(modetrans);
	for i=y1+8,y2,2 do
		rectfill(virt,x1+8,i,x2,i,makecol(40,40,120));
	end
	
	rectfill(virt,x1+8,y1+8,x2,y2,makecol(20,20,80));
	drawing_mode(modesolid);
end



function init_configuration()
	star={{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y}};
	star1={{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y}};
	star2={{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},
		  {x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y},{x,y}};
	set_uformat(get_allegro_def("U_UTF8"));
	allegro_init();
	install_timer();
	install_keyboard();
	install_mouse();
	alfont_init();
	set_color_depth(16);
	if set_gfx_mode(get_allegro_def("GFX_AUTODETECT"),640,480,0,0) ~=0 then
		print (translate("Unable to set the graphic mode for launching the configuration script."));
		print (translate("Assuming defaults."));
		exit();
	end
	virt=create_bitmap(640,480);
	if virt==nil then
		print (translate("Unable to create the virtual screen."));
		print (translate("Assuming defaults."));
		exit();
	end
	
	for i=1,30 do
		star[i].x=math.random(640);
		star[i].y=math.random(480);
		star1[i].x=math.random(640);
		star1[i].y=math.random(480);
		star2[i].x=math.random(640);
		star2[i].y=math.random(480);
	end
	
	data=load_datafile("data/phantstp.dat");
	f = alfont_load_font("data/fonts/VeraBd.ttf");
	f1 = alfont_load_font("data/fonts/Vera.ttf");
	
	cursor=get_datafile_object(data,"ARROW_BMP");
	bt_ok=get_datafile_object(data,"BUTTON_OK_BMP");
	bt_cancel=get_datafile_object(data,"BUTTON_CANCEL_BMP");
	border={};
	border[0]=create_bitmap(1,1);
	clear_to_color(border[0],makecol(0,0,0));
	border[1]=get_datafile_object(data,"BORDER1_BMP");
	border[2]=get_datafile_object(data,"BORDER2_BMP");
	border[3]=get_datafile_object(data,"BORDER3_BMP");
	border[4]=get_datafile_object(data,"BORDER4_BMP");
	border[5]=get_datafile_object(data,"BORDER5_BMP");
	border[6]=get_datafile_object(data,"BORDER6_BMP");
	border[7]=get_datafile_object(data,"BOX1_BMP");
	border[8]=get_datafile_object(data,"BOX2_BMP");
	border[9]=get_datafile_object(data,"WIDGET1_BMP");
	border[10]=get_datafile_object(data,"WIDGET2_BMP");
	modetrans=get_allegro_def("DRAW_MODE_TRANS");
	modesolid=get_allegro_def("DRAW_MODE_SOLID");
	set_trans_blender(187,187,187,187);
	set_mouse_range(80,80,560,360);
	alfont_set_font_size(f, 25);
	alfont_set_font_size(f1, 15);
	set_trans_blender(187,187,187,187);
	
	while(1) do
		clear_to_color(virt,makecol(0,0,0));
		
		draw_stars();
		draw_border(80,80,560,360);	
		alfont_textout_centre_aa(virt,f,translate(" Welcome to Phantomas PC"),321,141,makecol(100,100,100));
		alfont_textout_centre_aa(virt,f,translate(" Welcome to Phantomas PC"),321,137,makecol(100,100,100));
		alfont_textout_centre_aa(virt,f,translate(" Welcome to Phantomas PC"),320,139,makecol(100,100,100));
		alfont_textout_centre_aa(virt,f,translate(" Welcome to Phantomas PC"),322,139,makecol(100,100,100));
		alfont_textout_centre_aa(virt,f,translate(" Welcome to Phantomas PC"),321,139,makecol(250,250,250));
		alfont_textout_centre_aa(virt,f1,translate(" It seems that this is the first time you are running this game."),321,195,makecol(250,250,250));
		alfont_textout_centre_aa(virt,f1,translate(" Do you want to configure it now?"),320,220,makecol(250,250,250));
		draw_trans_sprite(virt,bt_ok,320-128,260);
		draw_trans_sprite(virt,bt_cancel,320+64,260);
	
		if ppc(bt_ok,320-128,260,cursor,xm,ym)~=0 then
			draw_sprite(virt,bt_ok,320-128,260);
			if get_mouse_b()==1 then
				setup_main_menu();
				break;
			end
		end
		
		if ppc(bt_cancel,320+64,260,cursor,xm,ym)~=0 then
			draw_sprite(virt,bt_cancel,320+64,260);
			if get_mouse_b()==1 then
				break;
			end
		end

		xm=get_mouse_x();
		ym=get_mouse_y();
		draw_sprite(virt,cursor,xm,ym);
		vsync();
		blit(virt);
		if (xm>600) then
			break;
		end
	end

	destroy_bitmap(virt);
	unload_datafile(data);
	alfont_destroy_font(f);
	alfont_destroy_font(f1);
	alfont_exit();
	allegro_exit();
end

init_configuration();
