#ifndef _TESC_SELECCION_IDIOMA_
#define _TESC_SELECCION_IDIOMA_

#include "escenarios.h"

REGISTER_CLASS_ID(TESC_Seleccion_Idioma);
TMAString TESC_Seleccion_Idioma::ia_himnos[4][2] = 
{
    {"Data/Idioma/Himnos/espana.ogg","ESPAOL"},
    {"Data/Idioma/Himnos/inglaterra.ogg","ENGLISH"},
    {"Data/Idioma/Himnos/francia.ogg","FRANAIS"},
    {"Data/Idioma/Himnos/alemania.ogg","DEUTSCH"}
};
int TESC_Seleccion_Idioma::ia_cursor_pos[] = { 76,216,356,496};

TESC_Seleccion_Idioma::TESC_Seleccion_Idioma():TMAScene()
{
    miGame = (TProfanationGame*)TMAGame::getCurrentGame();
}

TESC_Seleccion_Idioma::~TESC_Seleccion_Idioma()
{
    if (io_Screen!=NULL)
    {
        delete io_Screen;
        io_Screen = NULL;
    }
    if (sprSeleccion!=NULL) delete sprSeleccion;
    if (masoft!=NULL) delete masoft;
}

bool TESC_Seleccion_Idioma::doInit(const PMAObject params)
{    
    li_alpha=0;

    if (!map.setMapFile("Data/Idioma.mpb"))
    {
        miGame->showFatalError("No se puede cargar archivo de mapa.");
        return false;
    }
    
    io_Screen = NULL; 
    gotoSelectLanguage();

    if (io_Screen)
    {
        masoft = TMABitmap::loadFromFile("Data/Idioma/masoft.png");
        sprSeleccion = new TSprSeleccion(map.getImageBank(2),true,this);
        sprSeleccion->putAt(ia_cursor_pos[miGame->gi_idioma],276);
    }

    return (io_Screen!=NULL);
}        

bool TESC_Seleccion_Idioma::doRun(void)
{
    doRunLanguage();    
    return false;
}

void TESC_Seleccion_Idioma::doPaint(TMABitmap& buff)
{
    doPaintLanguage(buff);
};

void TESC_Seleccion_Idioma::doPaintLanguage(TMABitmap& buff)
{
    buff.clear(map.getBackgroundColor());
    map.drawScreen(buff,io_Screen);
    
    sprSeleccion->animate();
    sprSeleccion->draw(buff);
    miGame->fontBlue.drawText(buff,ia_himnos[miGame->gi_idioma][1].text(),-1,360,NULL,640);
    
    if (li_alpha<255)
    {
        buff.setAlpha(li_alpha); li_alpha+=2;
        buff.drawAlpha(masoft,70,50);
        buff.setAlpha(255);
    }
    else  buff.draw(masoft,70,50,true);
}

void TESC_Seleccion_Idioma::doRunLanguage(void)
{
	poll_joystick();
    if (joy[0].stick[0].axis[0].d1 && miGame->gi_idioma>0 && !sprSeleccion->isMoving())
	{
		sprSeleccion->gi_idioma = (miGame->gi_idioma-1);
		sprSeleccion->moveTo(ia_cursor_pos[sprSeleccion->gi_idioma],sprSeleccion->position.y);
	}
	else if (joy[0].stick[0].axis[0].d2 && miGame->gi_idioma<4 && !sprSeleccion->isMoving())
	{
		sprSeleccion->gi_idioma = (miGame->gi_idioma+1);
		sprSeleccion->moveTo(ia_cursor_pos[sprSeleccion->gi_idioma],sprSeleccion->position.y);
	}
	else if ( (joy[0].button[6].b || joy[0].button[7].b) && !sprSeleccion->isMoving()) gotoMainMenu();
	
}


void TESC_Seleccion_Idioma::playCountryMidi(void)
{
}

void TESC_Seleccion_Idioma::languageChanged(void)
{
    miGame->gi_idioma = sprSeleccion->gi_idioma;
    playCountryMidi();
    miGame->saveConfiguration();
}

void TESC_Seleccion_Idioma::gotoSelectLanguage(void)
{
    miGame->releaseKeys();
    ii_Estado=-1;
    if (io_Screen!=NULL) delete io_Screen;
    io_Screen = map.getScreen(1);
	playCountryMidi();
	ii_Estado=0;
}


void TESC_Seleccion_Idioma::gotoMainMenu(void)
{
	ii_Estado=-1;
    miGame->gi_idioma_anterior = miGame->gi_idioma;
	miGame->setScene(new TESC_Juego());
}

	    
#endif
