#ifndef _MA_ALLEGRO_CPP_
#define _MA_ALLEGRO_CPP_

#include "ma_allegro.h"

REGISTER_CLASS_ID(TMAObject);

TMAObject::~TMAObject(){}
bool TMAObject::isInstanceOf(long class_id)
{
    return (classID()==class_id);
}
long TMAObject::getClassID(void)
{
    return classID();
}

void close_button_handler(void)
{
    TMAGame::endGame();
}

void count_millis(void)
{
    TMAGame::il_time_millis++;
}
END_OF_FUNCTION(count_millis);

// Punto de entrada principal, que se redireccionara al metodo MainProc
//
int main(int argc,char **argv) 
{
    if (allegro_init()!=0)
    {
         allegro_message("No se pueden inicializar las rutinas.");
         return -1;
    }
    
    if (install_timer()!=0)
    {
         allegro_message("No se pueden inicializar las rutinas de timer.");
         return -1;
    }    
    
    // Instalamos el Timer, para contar en milisegundos.
    //
    LOCK_VARIABLE(TMAGame::il_time_millis);
    LOCK_FUNCTION(count_millis);
    install_int(count_millis,1);
    
    if (install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,0)==0)
    {
        TMAGame::setSoundAvailable(true);
    }
    
    // Registramos el formato PNG
    //
    register_png_file_type();
    
    // Establecemos el manejador para cerrar la ventana
    //
    LOCK_FUNCTION(close_button_handler);
    set_close_button_callback(close_button_handler);
      
	int ret = MainProc(argc,argv);
	return ret;
}
END_OF_MAIN()


#endif
