#ifndef _TMASOUND_CPP_
#define _TMASOUND_CPP_

#include "../gp2x/volume.h"
#include "ma_allegro.h"

REGISTER_CLASS_ID(TMASound);

TMASound::TMASound()
{
    psound=NULL;
    ii_voice=-1;
}

TMASound::~TMASound()
{
    unload();
}

void TMASound::unload(void)
{
    if (psound!=NULL) 
    {
        destroy_sample(psound);
        psound=NULL;
    }
}
 
bool TMASound::load(const char *filename)
{
    stop();
    if (psound!=NULL)
    {
        destroy_sample(psound);
        psound=NULL;
    }
    psound = load_sample(filename);
    return (psound!=NULL);
}

void TMASound::play(bool loop,int volume)
{
    if (psound!=NULL)
    {
        if (volume>255) volume=255;
        ii_voice = play_sample(psound,255,127,1000,loop);
    }        
}

void TMASound::stop(void)
{
    if (psound!=NULL) stop_sample(psound);
}

bool TMASound::isPlaying(void)
{
    if (psound!=NULL && ii_voice>=0)
    {
        return (voice_check(ii_voice)==psound);
    }
    return false;
}
            
#endif
