#ifndef _PROFANATION_H_
#define _PROFANATION_H_

#include "../ma_allegro/ma_allegro.h"
#include "../ma_allegro/maps/mapas.h"

class TProfanationGame:public TMAGame
{
    REGISTER_CLASS protected:
        
    public:
        PUBLIC_CLASS_ID;
        
        // Idiomas y Juegos de Caracteres
        //
        static TMAString gs_charset;
        static const int LG_SPAIN=0;
        static const int LG_ENGLISH=1;
        static const int LG_FRENCH=2;
        static const int LG_DEUTCH=3;
        
        // Valores de las teclas
        //
        static const int GKEY_LEFT=0;
        static const int GKEY_RIGHT=1;
        static const int GKEY_UP=2;
        static const int GKEY_DOWN=3;
        static const int GKEY_ABORT=4;
        static int ga_GameKeys[5];
        
        // Mapas y Tipos de Letras
        //
        static int gi_idioma,gi_idioma_anterior; 
        TMAFont fontBlue;
        TMAFont fontMulti;
        
        bool config_fullscreen;
        bool lb_init;
        
        TMASound gsnd_Gota;
        TMASound gsnd_Roca;
        TMASound gsnd_Camina;
        TMASound gsnd_Salto;
        TMASound gsnd_Caida;
        TMASound gsnd_Tesoro;
        TMASound gsnd_Scroll;
        TMASound gsnd_Teletransporte;
        TMASound gsnd_Grito;
        
        TMARandom miRND;
        
        // Constructor y Mtodos
        //
        ~TProfanationGame();  
        
        bool init(void);
        void cleanup(void);
        void doRun(void);
        void doPaint(TMABitmap&);
        
        bool testKey(int pkey) { return key[ga_GameKeys[pkey]]; }
        void releaseKey(int pkey) { key[ga_GameKeys[pkey]]=false; }
        
        void loadConfiguration(void);
        void saveConfiguration(void);
        
        void setFullScreen(bool);
};


#endif
