#ifndef _TMAMIDI_CPP_
#define _TMAMIDI_CPP_

#include "ma_allegro.h"

REGISTER_CLASS_ID(TMAMidi);
MIDI* TMAMidi::sp_current_midi=NULL;

TMAMidi::TMAMidi()
{
    pmidi=NULL;
}

TMAMidi::~TMAMidi()
{
    clear();
}
 
void TMAMidi::clear(void)
{
    if (pmidi!=NULL)
    {
        if (sp_current_midi==pmidi) stop();
        sp_current_midi=NULL;
        destroy_midi(pmidi);
        pmidi=NULL;
    }
}

bool TMAMidi::load(const char *filename)
{
    stop();
    pmidi = load_midi(filename);
    return (pmidi!=NULL);
}

void TMAMidi::play(bool loop)
{
    if (pmidi!=NULL)
    {
        if (sp_current_midi!=NULL) stop_midi();
        sp_current_midi = pmidi;
        play_midi(sp_current_midi,loop);
    }        
}

void TMAMidi::stop(void)
{
    if (pmidi==sp_current_midi) stop_midi();
}
            
void TMAMidi::pause(void)
{
    if (pmidi==sp_current_midi) midi_pause();
}

void TMAMidi::resume(void)
{
    if (pmidi==sp_current_midi) midi_resume();
}

#endif
