#ifndef _GLAURUNG_CPP_
#define _GLAURUNG_CPP_

#include "profanation.h"
#include "../escenas/escenarios.h"

// **************************************
// Definicin de mtodos de clase TMAGame
// **************************************
//
REGISTER_CLASS_ID(TProfanationGame);

TMAString TProfanationGame::gs_charset("ABCDEFGHIJKLMNOPQRSTUVWXYZ:.,()*0123456789 '-");

int TProfanationGame::ga_GameKeys[5]={KEY_LEFT,KEY_RIGHT,KEY_UP,KEY_DOWN,KEY_ESC};
int TProfanationGame::gi_idioma=TProfanationGame::LG_SPAIN;
int TProfanationGame::gi_idioma_anterior=TProfanationGame::LG_SPAIN;

// --------- IMPLEMENTACION DE DESTRUCTOR
//
TProfanationGame::~TProfanationGame()
{
    cleanup();
}

void TProfanationGame::cleanup(void)
{
}

void TProfanationGame::setFullScreen(bool fs)
{
    config_fullscreen = fs;
    setGraphicsMode(640,480,16,config_fullscreen);
    saveConfiguration();
}

// --------- INICIALIZACION DEL JUEGO
//
bool TProfanationGame::init(void)
{ 
    lb_init=false; 
     
    if (!TMAGame::init()) return false;
    loadConfiguration();
    //setWindowTitle("Abusimbel Profanation Deluxe");
    if (!setGraphicsMode(640,480,16,config_fullscreen)) return false;
    setGameFPS(32);
    
    lb_init = true;
                
    // Cargamos los tipos de letras constantes en el juego
    //
    fontBlue.load("Data/Fonts/FuenteBlue.png",20,30,gs_charset.length(),1,true,getRGBColor(255,0,255));
    fontBlue.setCharacters(*gs_charset);
    fontMulti.load("Data/Fonts/FuenteMulti.png",20,30,gs_charset.length(),1,true,getRGBColor(255,0,255));
    fontMulti.setCharacters(*gs_charset);
    
    // Cargamos los sonidos
    //
    if (isSoundAvailable())
    {
        gsnd_Gota.load("Data/Sonidos/gota.wav");
        gsnd_Roca.load("Data/Sonidos/roca.wav");
        gsnd_Camina.load("Data/Sonidos/camina.wav");
        gsnd_Salto.load("Data/Sonidos/salto.wav");
        gsnd_Caida.load("Data/Sonidos/caida.wav");
        gsnd_Tesoro.load("Data/Sonidos/tesoro.wav");
        gsnd_Scroll.load("Data/Sonidos/scroll.wav");
        gsnd_Teletransporte.load("Data/Sonidos/teletransporte.wav");
        gsnd_Grito.load("Data/Sonidos/grito.wav");
    }
    
    miRND.init();
    
    // Establecemos el escenario inicial
    //    
    setScene(new TESC_Seleccion_Idioma());
    
    return true;
}


void TProfanationGame::doRun(void)
{
	poll_joystick();
    if (joy[0].button[10].b && joy[0].button[7].b)
    {
        this->endGame();
        return;
    }
}

void TProfanationGame::doPaint(TMABitmap& buff)
{
    buff.clear(0);
};

void TProfanationGame::loadConfiguration(void)
{
 config_fullscreen = false;
 
 // Intentamos abrir el archivo de configuracion
 //
 FILE *f = fopen("Data/config","rb");
 
 // Si no existe, intentamos crear uno con los valores actuales.
 //
 if (!f)
 {
  saveConfiguration();
  return;
 }
 
 // Leemos los valores.
 //
 fread(&config_fullscreen,sizeof(config_fullscreen),1,f);
 fread(&TProfanationGame::gi_idioma,sizeof(TProfanationGame::gi_idioma),1,f);
 fread(&TProfanationGame::gi_idioma_anterior,sizeof(TProfanationGame::gi_idioma_anterior),1,f);
 fread(&TProfanationGame::ga_GameKeys[0],sizeof(TProfanationGame::ga_GameKeys),1,f);
 fclose(f);
}

void TProfanationGame::saveConfiguration(void)
{
 // Intentamos crear el archivo de configuracion
 //
 FILE *f = fopen("Data/config","wb");
 
 // Si no podemos crearlo, desistimos
 //
 if (!f) return;
 
 // Escribimos los valores.
 //
 config_fullscreen = (lb_init)?this->isFullScreen():false;
 fwrite(&config_fullscreen,sizeof(config_fullscreen),1,f);
 fwrite(&TProfanationGame::gi_idioma,sizeof(TProfanationGame::gi_idioma),1,f);
 fwrite(&TProfanationGame::gi_idioma_anterior,sizeof(TProfanationGame::gi_idioma_anterior),1,f);
 fwrite(&TProfanationGame::ga_GameKeys[0],sizeof(TProfanationGame::ga_GameKeys),1,f);
 fclose(f);
}

int MainProc(int argc, char** argv)
{ 
    TProfanationGame miGame;
    
    if (miGame.init())
    {
        miGame.run();
        return 0;
    }
    else
    {
        miGame.showAlert("No se pudo inicializar la aplicacin.");
    }
    return -1;    
}

#endif
