#ifndef _TGOTA_
#define _TGOTA_

#include "sprites.h"
#include "../escenas/escenarios.h"

REGISTER_CLASS_ID(TSprGota);

int TSprGota::AnimRojo[7]       ={18,19,20,21,22,23,24};
int TSprGota::AnimAmarillo[7]   ={35,36,37,38,39,40,41};
int TSprGota::AnimVerde[7]      ={52,53,54,55,56,57,58};
int TSprGota::AnimAzul[7]       ={69,70,71,72,73,74,75};

TSprGota::TSprGota(PMAImageBank bank,int tipo,int posx,int posy,int pinity,int pendy,int vel,int pausa_rota):TMASprite(bank)
{
    miGame = (TProfanationGame*)TMAGame::getCurrentGame();

    pausa_rotura=pausa_rota;
    if (pausa_rotura==0) pausa_rotura=1;

    switch (tipo)
    {
    case TSPR_GOTA_ROJA:
        setAnimSequence(AnimRojo,7);
        break;
    case TSPR_GOTA_AMARILLA:
        setAnimSequence(AnimAmarillo,7);
        break;
    case TSPR_GOTA_VERDE:
        setAnimSequence(AnimVerde,7);
        break;
    case TSPR_GOTA_AZUL:
        setAnimSequence(AnimAzul,7);
        break;
    default:
         allegro_message("ERROR AL CREAR TIPO DE GOTA");
    }

    init_y = pinity*_TileAY;
    end_y  = pendy*_TileAY;
    velocidad=vel;

    // Definimos la posicin inicial y el tamao del Sprite
    //
    position.x = posx*_TileAX;
    position.y = init_y;
    position.width = 40;
    position.height = 40;

    // Establecemos el primer fotograma de la animacin.
    //
    if (posy>pinity)
    {
        position.y = posy*_TileAY;
        ii_Frame=2;
        ii_Estado=10;
    }
    else
    {
        ii_Frame=0;
        ii_Estado=0;
    }
}

void TSprGota::animate(void)
{
    // Animamos la gota.
    //
    switch (ii_Estado)
    {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
    
            // Los 2 primeros fotogramas son la condensacin de la gota.
            if (ii_Estado==4 || ii_Estado==9) ii_Frame++;
            ii_Estado++;
            break;
    
        case 10:
            ii_Estado++;
            break;
    
        case 11:
            // Hacemos que la gota caiga hasta que llegue a su fin.
            if (position.y < end_y)
            {
                position.y += velocidad;
            }
            else
            {
                position.y = end_y;
                ii_Frame++;
                ii_Estado++;
                if (miGame->isSoundAvailable()) miGame->gsnd_Gota.play();
            }
            break;
    
        default:
     
            if (!(ii_Estado % pausa_rotura)) 
            {
                ii_Frame++;
            }
            ii_Estado++;
    
            if (ii_Frame==7)
            {
                ii_Frame=0;
                ii_Estado=0;
                position.y = init_y;
            }
            break;
    }
    
    TMASprite::animate();
}

bool TSprGota::draw(TMABitmap& g)
{
    g.drawSpriteAlpha(io_images->getBitmap(ii_CurrentFotograma),position.x,position.y,ib_flip_x,ib_flip_y,150);
    return true;
}

#endif
