#ifndef _TPROTA_
#define _TPROTA_

#include "sprites.h"
#include "../escenas/escenarios.h"
#include "../gp2x/volume.h"

#define _VELOCIDAD_ANDAR_ 4
#define _VELOCIDAD_SALTAR_ 6
#define _CORRIGE_POSICION_ 10

#define _MASK_NADA_             0
#define _MASK_PARED_            1
#define _MASK_MUERTE_           2
#define _MASK_COGE_TESORO_      3
#define _MASK_TRANSITO_         4
#define _MASK_INICIO_JOHNY_     5
#define _MASK_PON_TESORO_       6


REGISTER_CLASS_ID(TSprJohny);

int TSprJohny::ia_AnimAndando[48]={1,2,3,4,1,2,3,4,1,2,3,4,1,2,3,4,
                                5,6,7,8,5,6,7,8,5,6,7,8,5,6,7,8,
                                9,10,11,12,9,10,11,12,9,10,11,12,9,10,11,12};
int TSprJohny::ia_AnimParado[12]={15,13,15,14,15,16,15,14,15,13,15,16};
int TSprJohny::ia_AnimSaltando[12]={17,17,17,17,17,17,17,17,17,17,17,17};

void TSprJohny::pf_EstablecerAnimacion(int tipo)
{

    switch (tipo)
    {
    case ANIM_ANDANDO:
        setAnimSequence(ia_AnimAndando,48);
        ii_Retardo=2;
        break;

    case ANIM_PARADO:
        setAnimSequence(ia_AnimParado,12);
        ii_Retardo=60;
        break;

    case ANIM_SALTANDO:
        setAnimSequence(ia_AnimSaltando,12);
        ii_Retardo=60;
        break;

    case ANIM_MURIENDO:
        setAnimSequence(ia_AnimAndando,4);
        ii_Retardo=10;
        break;
    }

    ii_Frame=0;
}

TSprJohny::TSprJohny():TMASprite(NULL)
{
    miGame = (TProfanationGame*)TMAGame::getCurrentGame();
    screen = NULL;
}

void TSprJohny::init(TMAGameMap& m,int pbank)
{
    map = &m;
    io_images = map->getImageBank(pbank);
    
    detenerSalto();

	ii_vidas=10;	

    position.width = 40;
    position.height = 40;
    ii_tilesx = 2;
    ii_tilesy = 2;
    ii_Frame=0;
    ii_Estado=0;
    ib_suelo_mortal=false;
}

void TSprJohny::detenerSalto(void)
{
    ib_andando_izquierda=false;
    ib_andando_derecha=false;
    ib_saltando=false;
    il_longitud_salto=0;
    il_tiempo_salto=0;
    pf_EstablecerAnimacion(ANIM_PARADO);
}

void TSprJohny::pf_CorregirPosicion(void)
{
    int px1,py1;

    px1 = ((position.x + _CORRIGE_POSICION_) / _TileAX);
    py1 = ((position.y  + _CORRIGE_POSICION_) / _TileAY);

	position.x = (px1*_TileAX);
    position.y = (py1*_TileAY);
}

void TSprJohny::pf_CorregirPosicionX(void)
{
    position.x = _TileAX * ((position.x + _CORRIGE_POSICION_) / _TileAX);
}

void TSprJohny::pf_CorregirPosicionY(void)
{
    position.y = ((position.y + _CORRIGE_POSICION_) / _TileAY)*_TileAY;
}

void TSprJohny::putAt(int px,int py)
{
    detenerSalto();
    position.x = px*_TileAX;
    position.y = py*_TileAY;
    GuardarPosicion();
    pf_EstablecerAnimacion(ANIM_PARADO);
    ii_Frame=0;
}

void TSprJohny::animate(bool control)
{
    ii_CurrentFotograma = ia_AnimSequence[ii_Frame];

    // Detectamos el movimiento del Sprite
	//
	if (control && (ii_Estado==0)) pf_ControlMovimiento();
    
	switch (ii_EstadoAnim)
	{
	  case 0: // Animacin Andando Normal.

		if (ii_RetardoPos<ii_Retardo)
		{
			ii_RetardoPos ++;
		}
		else
		{
			ii_Frame = (ii_Frame<ii_AnimSequenceLength-1)?(ii_Frame+1):0;
			ii_RetardoPos=0;
		}

		break;
	}
}


void TSprJohny::Matar(bool m)
{
    if (m)
    {
      ii_Estado=1;
      if (miGame->isSoundAvailable()) miGame->gsnd_Grito.play();
    }
    else
    {
      ib_suelo_mortal=false;
      ii_Estado=0;
    }
}

bool TSprJohny::draw(TMABitmap& g)
{
    // Dibujamos el Sprite
    //
    if (ii_Estado==0)
    {
        // Caso de juego normal
        //
        g.drawSprite(io_images->getBitmap(ii_CurrentFotograma),position.x,position.y,ib_flip_x,ib_flip_y);
    }
    else
    {
        // Caso de Sprite muriendo..
        //
        g.drawSpriteAlpha(io_images->getBitmap(ii_CurrentFotograma),position.x,position.y,ib_flip_x,ib_flip_y,256-ii_Estado);
        ii_Estado+=10;
        // Indicamos que el Sprite ha muerto.
        if (ii_Estado>=256) 
        {
            detenerSalto();
            ii_Estado=0;
            return false;
        }
    } 
	
    return true;
}

void TSprJohny::pf_RealizarSalto(void)
{    
    // Mientras podamos subir lo hacemos.
    //
    if (il_tiempo_salto>0)
    {
        il_tiempo_salto--;
        
        if (il_longitud_salto>0)
        {
            il_longitud_salto--;
            
            if (!pf_HayTecho())
            {
                position.y -= _VELOCIDAD_SALTAR_;
            }
        }

        if (miGame->isSoundAvailable() && !miGame->gsnd_Salto.isPlaying())
        {
            miGame->gsnd_Salto.play();
        }
    }
    else
    {
        // Ahora hemos de empezar a caer.
        //
        if (!pf_HaySuelo())
        {
            position.y += _VELOCIDAD_SALTAR_;
            
            if (miGame->isSoundAvailable() && !miGame->gsnd_Caida.isPlaying())
            {
                miGame->gsnd_Caida.play();
            }
        }
        else
        {
            // Caso que hayamos topado con el suelo.
            //
            if (miGame->isSoundAvailable())
            {
                if (miGame->gsnd_Caida.isPlaying()) miGame->gsnd_Caida.stop();
                if (miGame->gsnd_Salto.isPlaying()) miGame->gsnd_Salto.stop();
            }

            // Si al terminar el salto nos hemos metido en el decorado
            // entonces corregimos la posicin.
            //
            pf_CorregirPosicion();
            
            if (pf_DentroTierra())
            {                
                /*
                if (ib_andando_izquierda) position.x += _TileAX;
                if (ib_andando_derecha) position.x -= _TileAX;
                */
                position.y -= _TileAY;
            }
            
            detenerSalto();
            return;
        }
    }

    // Caso que se este saltando hacia la izquierda.
    //
    if (ib_andando_izquierda)
    {
        if (pf_PosibleCaminarIzquierda())
        {
            position.x -= _VELOCIDAD_ANDAR_;
        }
    }

    // Caso que se este saltando hacia la derecha
    //
    else if (ib_andando_derecha)
    {
        if (pf_PosibleCaminarDerecha())
        {
            position.x += _VELOCIDAD_ANDAR_;
        }
    }

}

void TSprJohny::pf_ControlMovimiento(void)
{
    if (ib_saltando)
    {
        pf_RealizarSalto();
        return;
    }

    if (!pf_HaySuelo())
    {
        if (miGame->isSoundAvailable())
        {
            if (miGame->gsnd_Camina.isPlaying()) miGame->gsnd_Camina.stop();
            if (!miGame->gsnd_Caida.isPlaying()) miGame->gsnd_Caida.play();
        }
        pf_CorregirPosicionX();
        position.y += _VELOCIDAD_SALTAR_;
        return;
    }
    else
    {
        if (miGame->isSoundAvailable() && miGame->gsnd_Caida.isPlaying()) miGame->gsnd_Caida.stop();
        pf_CorregirPosicionY();
    }

	poll_joystick();
	
	// - volumen
	if (joy[0].button[8].b)
	{
		set_volume(0,0);
	}
	// + volumen
	if (joy[0].button[9].b)
	{
		set_volume(255,0);
	}
    // Intentando Caminar hacia la izquierda
	//
	if (joy[0].stick[0].axis[0].d1)
	{		
		// Determinamos si el personaje puede andar hacia la izquierda
		//
		if (pf_PosibleCaminarIzquierda())
		{
            // Determinamos la animacin.
            //
            if (!ib_andando_izquierda)
            {
                ib_andando_derecha=false;
                ib_andando_izquierda=true;
                pf_EstablecerAnimacion(ANIM_ANDANDO);
            }
			
            // Si anteriormente estaba andando hacia la derecha, justo al
            // pulsar la izquierda, no se desplaza, solo cambia de sentido.
            //
			if (!ib_flip_x)
            {
                ib_flip_x=true;
            }
            else
            {
                position.x -= _VELOCIDAD_ANDAR_;
            }
        }
    }

    // Intentando caminar hacia la derecha.
    //
    else if (joy[0].stick[0].axis[0].d2)
    {
		// Determinamos si el personaje puede andar hacia la derecha
		//
		if (pf_PosibleCaminarDerecha())
		{
			// Determinamos la animacin.
            //
            if (!ib_andando_derecha)
            {
                ib_andando_derecha=true;
                ib_andando_izquierda=false;
                pf_EstablecerAnimacion(ANIM_ANDANDO);
            }
			
            // Si anteriormente estaba andando hacia la derecha, justo al
            // pulsar la izquierda, no se desplaza, solo cambia de sentido.
            //
			if (ib_flip_x)
            {
                ib_flip_x=false;
            }
            else
            {
                position.x += _VELOCIDAD_ANDAR_;
            }
        }
    }
    else
    {
        // Caso que el personaje este parado.
        //
        if (ib_andando_izquierda || ib_andando_derecha)
        {
            if (miGame->isSoundAvailable() && miGame->gsnd_Camina.isPlaying())
            {
                miGame->gsnd_Camina.stop();
            }
            ib_andando_izquierda=false;
            ib_andando_derecha=false;
            pf_EstablecerAnimacion(ANIM_PARADO);
        }
    }

    if (joy[0].button[0].b || joy[0].button[3].b)
    {
        // Caso que se pretenda usar el salto largo.
        //
        ib_saltando=true;
        il_longitud_salto=(80/_VELOCIDAD_SALTAR_);
        il_tiempo_salto=il_longitud_salto + 2;

        if (joy[0].stick[0].axis[0].d1)
        {
            ib_andando_izquierda=true;
            ib_andando_derecha=false;
            ib_flip_x=true;
        }
        else if (joy[0].stick[0].axis[0].d2)
        {
            ib_andando_derecha=true;
            ib_andando_izquierda=false;
            ib_flip_x=false;
        }

        if (ib_andando_izquierda || ib_andando_derecha)
        {
            pf_EstablecerAnimacion(ANIM_SALTANDO);
        }

        if (miGame->isSoundAvailable() and miGame->gsnd_Camina.isPlaying())
        {
            miGame->gsnd_Camina.stop();
        }
        return;
    }
    else if (joy[0].button[2].b || joy[0].button[1].b)
    {
        // Caso que se pretenda usar el salto corto.
        //
        ib_saltando=true;

        il_longitud_salto=(40/_VELOCIDAD_SALTAR_);
        il_tiempo_salto=il_longitud_salto + 2;
        
        if (joy[0].stick[0].axis[0].d1)
        {
            ib_andando_izquierda=true;
            ib_andando_derecha=false;
            ib_flip_x=true;
        }
        else if (joy[0].stick[0].axis[0].d2)
        {
            ib_andando_derecha=true;
            ib_andando_izquierda=false;
            ib_flip_x=false;
        }

        if (ib_andando_izquierda || ib_andando_derecha)
        {
            pf_EstablecerAnimacion(ANIM_SALTANDO);
        }

        if (miGame->isSoundAvailable() and miGame->gsnd_Camina.isPlaying())
        {
            miGame->gsnd_Camina.stop();
        }
        return;
    }

    // Si el personaje esta andando, ponemos el sonidito.
    //
    if (!ib_saltando && (ib_andando_izquierda || ib_andando_derecha))
    {
        if (miGame->isSoundAvailable() and !miGame->gsnd_Camina.isPlaying())
        {
            miGame->gsnd_Camina.play();
        }
    }

}

bool TSprJohny::isEnterLeft(void)
{
    return (position.x < 0);
}

bool TSprJohny::isEnterRight(void)
{
    switch (screen->getID())
    {
    case 6:
        return (position.x >= 516);

    default:
        return (position.x + position.width > 640);
    }
}

bool TSprJohny::isEnterUp(void)
{
    return (position.y < 0);
}

bool TSprJohny::isEnterDown(void)
{
    return (position.y + position.height > 320);
}

void TSprJohny::enterLeft(void)
{
	position.x = 640 - position.width ;
	GuardarPosicion();
}

void TSprJohny::enterRight(void)
{
	position.x = 0;
	GuardarPosicion();
}


void TSprJohny::enterUp(void)
{	
	position.y = 320 - position.height;
	GuardarPosicion();
}

void TSprJohny::enterDown(void)
{
    position.y = 0;
	GuardarPosicion();
}

bool TSprJohny::pf_PosibleCaminarDerecha(void)
{
	int px,py,valor,i;

    px = (position.x + position.width + _VELOCIDAD_ANDAR_ - 1) / _TileAX;
    py = (position.y / _TileAY);

    if (px>31) return true;

	for (i=0;i<ii_tilesy;i++)
	{
       valor = screen->getMask(px,py+i);
       switch (valor)
       {
        case _MASK_TRANSITO_:
            return ((TESC_Juego*)miGame->getScene())->AbiertaPuertaSecreta();
            
        case _MASK_MUERTE_:
        case _MASK_NADA_:
        case _MASK_INICIO_JOHNY_:
            break;

        case _MASK_COGE_TESORO_:
            ((TESC_Juego*)miGame->getScene())->CogerTesoro();
            return false;

        case _MASK_PON_TESORO_:
            ((TESC_Juego*)miGame->getScene())->PonerTesoro();
            return false;

        default:
            return false;
       }
	}
	return true;
}

bool TSprJohny::pf_PosibleCaminarIzquierda(void)
{
    int px,py,valor;
	
    px = (position.x - _VELOCIDAD_ANDAR_) / _TileAX;
    py = (position.y / _TileAY);

    if (px<0) return true;

	for (int i=0;i<ii_tilesy;i++)
	{
	   valor = screen->getMask(px,py+i);
       switch (valor)
       {
        case _MASK_TRANSITO_:
            return ((TESC_Juego*)miGame->getScene())->AbiertaPuertaSecreta();
            
        case _MASK_MUERTE_:
        case _MASK_NADA_:
        case _MASK_INICIO_JOHNY_:
            break;

        case _MASK_COGE_TESORO_:
            ((TESC_Juego*)miGame->getScene())->CogerTesoro();
            return false;

        case _MASK_PON_TESORO_:
            ((TESC_Juego*)miGame->getScene())->PonerTesoro();
            return false;

        default:
            return false;
       }
	}
	return true;
}

bool TSprJohny::pf_HaySuelo(void)
{
    int px,py,valor;
	ib_suelo_mortal=false;
	
    px = ((position.x + _CORRIGE_POSICION_) / _TileAX);
    py = (position.y + position.height + _VELOCIDAD_SALTAR_ - 1) / _TileAY;

    if (py>15) return false;

	for (int i=0;i<ii_tilesx;i++)
	{
       valor = screen->getMask(px+i,py);
       switch (valor)
       {
        case _MASK_TRANSITO_:
            return (!((TESC_Juego*)miGame->getScene())->AbiertaPuertaSecreta());
            
        case _MASK_MUERTE_:
            ib_suelo_mortal=true;
        case _MASK_NADA_:
        case _MASK_INICIO_JOHNY_:
            break;

        case _MASK_COGE_TESORO_:
            ((TESC_Juego*)miGame->getScene())->CogerTesoro();
            return true;

        case _MASK_PON_TESORO_:
            ((TESC_Juego*)miGame->getScene())->PonerTesoro();
            return true;

        default:
            return true;
       }
    }
	return false;
}

bool TSprJohny::pf_HayTecho(void)
{
    int px,py,valor;
	
    px = ( (position.x + _CORRIGE_POSICION_) / _TileAX);
    py = (position.y - _VELOCIDAD_SALTAR_) / _TileAY;

    if (py<0) return false;

	for (int i=0;i<ii_tilesx;i++)
	{
        if (py>=0)
        {
		   valor = screen->getMask(px+i,py);
           switch (valor)
           {
            case _MASK_TRANSITO_:
                return (!((TESC_Juego*)miGame->getScene())->AbiertaPuertaSecreta());

            case _MASK_MUERTE_:
            case _MASK_NADA_:
            case _MASK_INICIO_JOHNY_:
                break;
    
            case _MASK_COGE_TESORO_:
                ((TESC_Juego*)miGame->getScene())->CogerTesoro();
                return true;

            case _MASK_PON_TESORO_:
                ((TESC_Juego*)miGame->getScene())->PonerTesoro();
                return true;

            default:
                return true;
           }
        }
	}
	return false;
}

bool TSprJohny::pf_DentroTierra(void)
{
    int px,py,valor;
	
    px = ( (position.x + _CORRIGE_POSICION_) / _TileAX);
    py = (position.y / _TileAY);

	for (int i=0;i<ii_tilesx;i++)
    {
        for (int j=0;j<ii_tilesy;j++)
        {
            if (py>=0 && px>=0)
            {
                valor = screen->getMask(px+i,py+j);
                if ( valor!=0 && valor!=_MASK_INICIO_JOHNY_) return true;
            }
	    }
    }
    
	return false;
}

void TSprJohny::GuardarPosicion(void)
{
    est_MemPos.setBounds(position);
    est_izquierda=ib_andando_izquierda;
    est_derecha=ib_andando_derecha;
    est_saltando=ib_saltando;
    est_longitud_salto=il_longitud_salto;
    est_tiempo_salto=il_tiempo_salto;

    est_animacion = ia_AnimSequence;
    est_longitud_animacion = ii_AnimSequenceLength;
    est_retardo_animacion = ii_Retardo;

    est_flip = ib_flip_x;
}

void TSprJohny::RestaurarPosicion(void)
{
    position.setBounds(est_MemPos);
    ib_andando_izquierda=est_izquierda;
    ib_andando_derecha=est_derecha;
    ib_saltando=est_saltando;
    il_longitud_salto=est_longitud_salto;
    il_tiempo_salto=est_tiempo_salto;

    setAnimSequence(est_animacion,est_longitud_animacion);
    ii_Retardo=est_retardo_animacion;

    ib_flip_x = est_flip;
}

bool TSprJohny::isCollisioningWith(TMASprite& s)
{
    TMARectangle s1,s2;
    if (ib_suelo_mortal) return true;
    
    s1.setBounds(position); 
    s1.width-=4;
    s1.height-=4;
    s1.x +=2;
    s1.y +=2;
    
    s2.setBounds(s.position);
    s2.width-=4;
    s2.height-=4;
    s2.x +=2;
    s2.y +=2;
    
    return s1.intersects(s2);
}

#endif
