// Compo entry for DIV-Arena
// Developed by SLAINTE
// Betatesting by ZAFA

PROGRAM TILT ;

CONST

  // Game state machine CONSTANTS (states)
  E_INITIALIZING = 0 ;
  E_INTRO        = 1 ;
  E_MENU         = 2 ;
  E_GAME         = 3 ;
  E_EXIT         = 4 ;
  E_LEVEL        = 5 ;
  E_SCORE        = 6 ;
  E_REPORT       = 7 ;
  E_TIMEOUT      = 8 ;
  E_INFO         = 9 ;

  // Game basic values
  LIFES          = 3 ;
  LTIME          = 150 ;
  LTIME_DEC      = 25 ;

  FPS_GAME       = 24 ;
  FPS_INC        = 6 ;

  LVL_TRIGGER    = 5 ;



GLOBAL

  INT fpgfile ;
  INT estado = 0 ;
  INT blocks[16] ;
  INT gfx_init = 0 ;
  INT score ;
  INT centros[] = 0,25,50,75,100,125,150,175 ;
  INT game_map = 0 ;
  INT map_changed = 0 ;
  INT cursor = 0 ;
  INT px,py ;
  INT module1,module2 ;
  INT fb,fbs ;
  INT pos,npos ;
  INT level = 0 ;
  INT lives = LIFES ;
  INT mid ;
  int time,timeo ;
  int move ;
  INT SENSIBILIDAD   = 5 ;
  INT bonus ;

  BYTE map_lv[63] ;
  BYTE map_lvo[63] ;

LOCAL

  INT i,j ;
  INT a,b ;
  INT drw ;
  INT lv[2] ;
  int txt ;

  // direct gfx info... just 8x8 bytes
  BYTE ball_gfx[] = 0,0,192,192,192,192,0,0,0,192,97,97,97,97,192,0,192,97,97,97,97,97,97,192,192,97,81,97,97,97,97,192,192,97,81,97,97,97,97,192,192,97,97,81,81,97,97,192,0,192,97,97,97,97,192,0,0,0,192,192,192,192,0,0 ;
  BYTE bonus_gfx[] = 60,0,0,0,0,0,0,60,0,0,60,60,60,60,0,0,0,60,0,0,0,0,60,0,0,60,0,60,60,0,60,0,0,60,0,60,60,0,60,0,0,60,0,0,0,0,60,0,0,0,60,60,60,60,0,0,60,0,0,0,0,0,0,60 ;
BEGIN

  // Initialization code
  FULL_SCREEN = false ;
  set_fps(FPS_GAME,0) ;
  set_mode(m320x240) ;
  clear_screen() ;

  // Resource loading
  fb = load_fnt("fnt/tilt.fnt") ;
  fbs = load_fnt("fnt/tilts.fnt") ;
  fpgfile = load_fpg("comp1.fpg") ;

  // Sound loading
  module1 = load_song("mod/menu.mod") ;
  module2 = load_song("mod/ingame.mod") ;
//  module2 = module1 ;

  // Main program LOOP - automaton
  WHILE (estado != E_EXIT)

    SWITCH (estado)

      CASE E_INITIALIZING:

        IF (gfx_init==0)

          // Must do all gfx generation here...
          // Generating MISC blocks

          blocks[15] = new_map(75,5,8) ; // Time marker
          set_center(0,blocks[15],0,0) ; 
          cursor = new_map(25,5,8) ;
          set_center(0,cursor,0,0) ;
          map_clear(0,cursor,find_color(255,0,0)) ;
          map_put(0,blocks[15],cursor,0,0) ;
          unload_map(0,cursor) ;
          cursor = new_map(25,5,8) ;
          set_center(0,cursor,0,0) ;
          map_clear(0,cursor,60) ;
          map_put(0,blocks[15],cursor,25,0) ;
          unload_map(0,cursor) ;
          cursor = new_map(25,5,8) ;
          set_center(0,cursor,0,0) ;
          map_clear(0,cursor,find_color(0,255,0)) ;
          map_put(0,blocks[15],cursor,50,0) ;
          unload_map(0,cursor) ;

          blocks[11] = new_map(24,24,8) ;
          set_center(0,blocks[11],0,0) ;
          map_put(0,blocks[11],2,4,4) ;
          map_put(0,blocks[11],2,12,4) ;
          map_put(0,blocks[11],2,20,4) ;
          map_put(0,blocks[11],2,4,20) ;
          map_put(0,blocks[11],2,12,20) ;
          map_put(0,blocks[11],2,20,20) ;
          map_put(0,blocks[11],2,20,12) ;

          blocks[14] = new_map(24,24,8) ;
          set_center(0,blocks[14],0,0) ;
          map_put(0,blocks[14],2,4,4) ;
          map_put(0,blocks[14],2,12,4) ;
          map_put(0,blocks[14],2,20,4) ;
          map_put(0,blocks[14],2,4,20) ;
          map_put(0,blocks[14],2,12,20) ;
          map_put(0,blocks[14],2,20,20) ;
          map_put(0,blocks[14],2,20,12) ;

          // putting arrows...
          //
          // OOOOOXXO
          // OOOOXXOO
          // OOOXXOOO
          // OOXXOOOO
          // OOXXOOOO
          // OOOXXOOO
          // OOOOXXOO
          // OOOOOXXO

          cursor = new_map(8,8,8) ;
          set_center(0,cursor,0,0) ;
          map_put_pixel(0,cursor,5,0,60) ;
          map_put_pixel(0,cursor,6,0,60) ;
          map_put_pixel(0,cursor,4,1,60) ;
          map_put_pixel(0,cursor,5,1,60) ;
          map_put_pixel(0,cursor,3,2,60) ;
          map_put_pixel(0,cursor,4,2,60) ;
          map_put_pixel(0,cursor,2,3,60) ;
          map_put_pixel(0,cursor,3,3,60) ;
          map_put_pixel(0,cursor,2,4,60) ;
          map_put_pixel(0,cursor,3,4,60) ;
          map_put_pixel(0,cursor,3,5,60) ;
          map_put_pixel(0,cursor,4,5,60) ;
          map_put_pixel(0,cursor,4,6,60) ;
          map_put_pixel(0,cursor,5,6,60) ;
          map_put_pixel(0,cursor,5,7,60) ;
          map_put_pixel(0,cursor,6,7,60) ;

          map_put(0,blocks[11],cursor,0,8) ;
          map_put(0,blocks[11],cursor,8,8) ;

          map_clear(0,cursor,0) ;
          
          map_put_pixel(0,cursor,1,0,60) ;
          map_put_pixel(0,cursor,2,0,60) ;
          map_put_pixel(0,cursor,2,1,60) ;
          map_put_pixel(0,cursor,3,1,60) ;
          map_put_pixel(0,cursor,3,2,60) ;
          map_put_pixel(0,cursor,4,2,60) ;
          map_put_pixel(0,cursor,4,3,60) ;
          map_put_pixel(0,cursor,5,3,60) ;
          map_put_pixel(0,cursor,4,4,60) ;
          map_put_pixel(0,cursor,5,4,60) ;
          map_put_pixel(0,cursor,3,5,60) ;
          map_put_pixel(0,cursor,4,5,60) ;
          map_put_pixel(0,cursor,2,6,60) ;
          map_put_pixel(0,cursor,3,6,60) ;
          map_put_pixel(0,cursor,1,7,60) ;
          map_put_pixel(0,cursor,2,7,60) ;
          
          map_put(0,blocks[14],cursor,1,8) ;
          map_put(0,blocks[14],cursor,9,8) ;

//          map_xput(0,blocks[14],cursor,8,8,0,100,1) ;
//          map_xput(0,blocks[14],cursor,8,8,0,100,1) ;

          unload_map(0,cursor) ;

          // Cursor block
          blocks[12] = new_map(24,24,8) ;
          set_center(0,blocks[12],0,0) ;
          map_clear(0,blocks[12],find_color(128,0,0)) ; // cursor

          // Ball gfx
          //
          // OOxxxxOO
          // OxssssxO
          // xssssssx
          // xs.ssssx
          // xs.ssssx
          // xss..ssx
          // OxssssxO
          // OOxxxxOO


          blocks[13] = new_map(8,8,8) ;
          set_centeR(0,blocks[13],0,0) ;
          FOR (i=0;i<64;i++)
            map_put_pixel(0,blocks[13],i MOD 8,i/8,ball_gfx[i]) ;
          END

          // Bonus gfx
          //
          // xOOOOOOx
          // OOxxxxOO
          // OxOOOOxO
          // OxOxxOxO
          // OxOxxOxO
          // OxOOOOxO
          // OOxxxxOO
          // xOOOOOOx

          blocks[16] = new_map(8,8,8) ;
          set_center(0,blocks[16],0,0) ;
          FOR (i=0;i<64;i++)
            map_put_pixel(0,blocks[16],i MOD 8,i/8,bonus_gfx[i]) ;
          END


          // Generating main blocks:
          //
          // XXX  X X  X X  XXX  X X  X X  X X  XXX  XXX  X X  X X
          //      X X                 X      X  X      X    X  X
          // XXX  X X  X X  X X  XXX  X X  X X  X X  X X  XXX  XXX

          blocks[0] = new_map(24,24,8) ;
          set_center(0,blocks[0],0,0) ;
          map_put(0,blocks[0],2,4,4) ;
          map_put(0,blocks[0],2,12,4) ;
          map_put(0,blocks[0],2,20,4) ;
          map_put(0,blocks[0],2,4,20) ;
          map_put(0,blocks[0],2,12,20) ;
          map_put(0,blocks[0],2,20,20) ;

          blocks[1] = new_map(24,24,8) ;
          set_center(0,blocks[1],0,0) ;
          map_put(0,blocks[1],1,4,16) ;
          map_put(0,blocks[1],1,20,16) ;

          blocks[2] = new_map(24,24,8) ;
          set_center(0,blocks[2],0,0) ;
          map_put(0,blocks[2],2,4,4) ;
          map_put(0,blocks[2],2,20,4) ;
          map_put(0,blocks[2],2,4,20) ;
          map_put(0,blocks[2],2,20,20) ;

          blocks[3] = new_map(24,24,8) :
          set_center(0,blocks[3],0,0) ;
          map_put(0,blocks[3],2,4,4) ;
          map_put(0,blocks[3],2,12,4) ;
          map_put(0,blocks[3],2,20,4) ;
          map_put(0,blocks[3],2,4,20) ;
          map_put(0,blocks[3],2,20,20) ;

          blocks[4] = new_map(24,24,8) ;
          set_center(0,blocks[4],0,0) ;
          map_put(0,blocks[4],2,4,4) ;
          map_put(0,blocks[4],2,20,4) ;
          map_put(0,blocks[4],2,4,20) ;
          map_put(0,blocks[4],2,12,20) ;
          map_put(0,blocks[4],2,20,20) ;

          blocks[5] = new_map(24,24,8) ;
          set_center(0,blocks[5],0,0) ;
          map_put(0,blocks[5],2,4,4) ;
          map_put(0,blocks[5],2,4,12) ;
          map_put(0,blocks[5],2,4,20) ;
          map_put(0,blocks[5],2,20,4) ;
          map_put(0,blocks[5],2,20,20) ;

          blocks[6] = new_map(24,24,8) ;
          set_center(0,blocks[6],0,0) ;
          map_put(0,blocks[6],2,20,4) ;
          map_put(0,blocks[6],2,20,12) ;
          map_put(0,blocks[6],2,20,20) ;
          map_put(0,blocks[6],2,4,4) ;
          map_put(0,blocks[6],2,4,20) ;

          blocks[7] = new_map(24,24,8) ;
          set_center(0,blocks[7],0,0) ;
          map_put(0,blocks[7],2,4,4) ;
          map_put(0,blocks[7],2,12,4) ;
          map_put(0,blocks[7],2,20,4) ;
          map_put(0,blocks[7],2,4,12) ;
          map_put(0,blocks[7],2,4,20) ;
          map_put(0,blocks[7],2,20,20) ;

          blocks[8] = new_map(24,24,8) ;
          set_center(0,blocks[8],0,0) ;
          map_put(0,blocks[8],2,4,4) ;
          map_put(0,blocks[8],2,12,4) ;
          map_put(0,blocks[8],2,20,4) ;
          map_put(0,blocks[8],2,20,12) ;
          map_put(0,blocks[8],2,4,20) ;
          map_put(0,blocks[8],2,20,20) ;

          blocks[9] = new_map(24,24,8) ;
          set_center(0,blocks[9],0,0) ;
          map_put(0,blocks[9],2,4,4) ;
          map_put(0,blocks[9],2,12,20) ;
          map_put(0,blocks[9],2,20,4) ;
          map_put(0,blocks[9],2,20,12) ;
          map_put(0,blocks[9],2,4,20) ;
          map_put(0,blocks[9],2,20,20) ;

          blocks[10] = new_map(24,24,8) ;
          set_centeR(0,blocks[10],0,0) ;
          map_put(0,blocks[10],2,4,4) ;
          map_put(0,blocks[10],2,12,20) ;
          map_put(0,blocks[10],2,20,4) ;
          map_put(0,blocks[10],2,4,12) ;
          map_put(0,blocks[10],2,4,20) ;
          map_put(0,blocks[10],2,20,20) ;

          gfx_init = 1 ;

        END

        estado=E_MENU ;

      END

      CASE E_INTRO:
        // Intro sequence...
        // None for now... :P maybe in a near future...
      END

      CASE E_MENU:
        // Into the menu system...
        set_fps(24,0) ;
        clear_screen() ;
        delete_text(all_text) ;

        stop_song() ;
        play_song(module1,-1) ;

        drawing_map(0,0) ;
        drawing_color(find_color(128,0,0)) ;
        draw_box(100,65,221,110) ;
        write(fb,160,90,4,"TILT") ;

        write(0,110,130,3,"1 - START GAME") ;
        write(0,110,145,3,"2 - GAME INFO") ;
        write(0,110,160,3,"3 - EXIT GAME") ;

        write(0,160,210,4,"COPYRIGHT 2002 - by Slinte") ;

        fade_on() ;
        while(fading)
          frame ;
        end

        WHILE (estado==E_MENU)
          IF (key(_1)) estado=E_GAME ; END
          IF (key(_2)) estado=E_INFO ; END
          IF (key(_3)) estado=E_EXIT ; END
          IF (key(_ESC)) estado=E_EXIT ; END
          FRAME ;
        END

        stop_song() ;

      END

      CASE E_INFO:

        clear_screen() ;
        delete_text(all_text) ;
        play_song(module2,-1);
        write(fb,160,40,4,"TILT") ;
        write(0,5,70,0,"Your mission is to guide your ball from the") ;
        write(0,5,80,0,"starting to the ending yellow arrows. The ball") ;
        write(0,5,90,0,"will only change directions when it hits a wall.") ;
        write(0,5,110,0,"Use the cursor keys to move your blank tile.  It") ;
        write(0,5,120,0,"will swap positions with the tile you move into.") ;
        write(0,5,140,0,"You must reach the ending arrows before you run") ;
        write(0,5,150,0,"out of energy.  Pick the yellow bonus energy") ;
        write(0,5,160,0,"cells to restore part of your energy level.") ;
        put(0,blocks[11],10,180) ;
        put(0,blocks[14],40,180) ;
        put(0,blocks[16],220,188) ;
        write(0,70,188,0,":starting/ending arrows") ;
        write(0,235,188,0,":energy cell") ;
        write(0,160,225,4,"PRESS ANY KEY TO CONTINUE") ;
        fade_on() ;
        while (fading)
          FRAME ;
        end
        WHILE (scan_code==0)
          FRAME ;
        END
        fade_off() ;
        while (fading)
          frame ;
        end
        estado=E_MENU ;
      END

      CASE E_GAME:

        // Playing the game
        clear_screen() ;
        delete_text(all_text) ;
        score = 0 ;
        lives = 3 ;
        level = 0 ;
        play_song(module2,-1) ;
        if (!is_playing_song()) play_song(module2,-1) ; END
        // Generate markers...
        define_region(1,225,85,75,5) ;
        drawing_color(find_color(255,255,255)) ;
        drawing_map(0,0) ;
        draw_line(225,82,299,82) ;
        draw_line(225,82,225,84) ;
        draw_line(299,82,299,84) ;
        time_counter_g() ;
        time_counter() ;
        draw_line(225,92,300,92) ;
        draw_line(225,91,225,92) ;
        draw_line(299,91,299,92) ;
        write(0,261,94,1,"ENERGY") ;
        write (fb,230,10,0,"TILT") ;
        drawing_color(find_color(255,0,0)) ;
        draw_rect(225,60,300,72) ;
        write(0,227,62,0,"BALLS:") ;
        FOR (i=0;i<lives;i++)
          lv[i] = live(270+i*10,62) ;
        END
        write(fbs,229,112,0,"LEVEL") ;
        write_int(fb,262,162,4,&level) ;
        // While in play...
        WHILE (estado==E_GAME)

          level++ ;
          // Generate level data and show the new map
          game_map = new_map(199,199,8) ;
          set_center(0,game_map,0,0) ; // Gaming area...
          map_clear(0,game_map,0) ;
          mid = mapa() ;
          cursor = rand(2,62) ;
          drawing_map(0,0) ;
          drawing_color(find_color(255,0,0)) ;
          draw_rect(7,18,210,220) ;
          map_lv[0] = 7 ;
          map_lvo[0] = 7 ;
          map_lv[1] = 11 ;
          map_lvo[1] = 11 ;
          map_lv[63] = 14 ;
          map_lvo[63] = 14 ;
          map_put(0,game_map,blocks[7],centros[0 MOD 8],centros[0/8]) ;
          j = 0 ;
          WHILE(j<2)
            j++ ;
            FRAME ;
          END
          map_put(0,game_map,blocks[11],centros[1 MOD 8],centros[1/8]) ;
          j = 0 ;
          WHILE(j<2)
            j++ ;
            FRAME ;
          END
          // random map generation
          FOR (i=2;i<63;i++)
            IF (i!=cursor)
              j = rand(0,10) ;
              map_put(0,game_map,blocks[j],centros[i MOD 8],centros[i/8]) ;
            ELSE
              a = i MOD 8 ; // Init cursor position
              b = i/8 ;
              j = 12 ;
              map_put(0,game_map,blocks[j],centros[i MOD 8],centros[i/8]) ;
            END
            map_lv[i] = j ;
            map_lvo[i] = j ;
            j = 0 ;
            WHILE(j<2)
              j++ ;
              FRAME ;
            END
          END

          map_put(0,game_map,blocks[14],centros[63 MOD 8],centros[63/8]) ;
          j = 0 ;
          WHILE(j<2)
            j++ ;
            FRAME ;
          END

          // Present the level entrance...

          mid.flags = 4 ;
          txt = write(fbs,110,120,4,"GET READY!!!") ;
          FRAME(5000) ;
          delete_text(txt) ;
          mid.flags = 0 ;

          // START LEVEL!
          time = 75 ;
          estado = E_LEVEL ;
          lives-- ;
          signal(lv[lives],S_KILL) ;
          timer=0 ;
          timer[1]=0 ;
          bonus = 0 ;
          bola(42,28) ;

          cursor++ ; // Notes: ball uses a 1 based position

          // DIFICULTY SETTINGS
          pos = level / LVL_TRIGGER ;

          IF (pos>2) pos = 2 ; END

          SWITCH (pos)

            CASE 0:
              timeo = 150 ;
              set_fps(24,0) ;
              SENSIBILIDAD = 3 ;
            END

            CASE 1:
              timeo = 125 ;
              set_fps(36,0) ;
              SENSIBILIDAD = 4 ;
            END

            CASE 2:
              timeo = 100 ;
              set_fps(48,0) ;
              SENSIBILIDAD = 5 ;
            END


          END
          pos = 2 ;

          WHILE (estado==E_LEVEL)
            // Bonuses...
            IF (timer[1]>=2000 && bonus == 0)
             bonus = rand(2,63) ;
             IF (bonus==cursor)
               IF (bonus>2)
                 bonus-- ;
               ELSE
                 bonus++ ;
               END
             END
             bono() ;
            END
            // Reset map changes
            map_changed = 0 ;
                        
            // Check cursor moves -> UP
            IF (move==0)
              IF (key(_UP) AND b>0 )
                IF ((b == 1 AND a > 1) OR b>1 )
                  IF (pos!=cursor-8 && npos!=cursor-8)
                    j = map_lv[(b-1)*8+a] ;
                    map_lv[b*8+a] = j ;
                    map_lv[(b-1)*8+a] = 12 ;
                    map_changed = 1 ;
                    b-- ;
                    cursor -= 8 ;
                    move = SENSIBILIDAD ;
                    IF (cursor==bonus+1) bonus+=8; END // this moves the bonus
                  END
                END
              END
              // Check cursor moves -> DOWN
              IF (key(_DOWN) AND b<7)
                IF ((b == 6 AND a < 7) OR b<6)
                  IF (pos!=cursor+8 && npos!=cursor+8)
                    j = map_lv[(b+1)*8+a] ;
                    map_lv[b*8+a] = j ;
                    map_lv[(b+1)*8+a] = 12 ;
                    map_changed = 1 ;
                    b++ ;
                    cursor+=8 ;
                    move = SENSIBILIDAD ;
                    IF (cursor==bonus+1) bonus-=8; END
                  END
                END
              END
              // Check cursor moves -> RIGHT
              IF (key(_RIGHT) AND a<7 )
                IF ((b==7 AND a<6) OR b<7)
                  IF (pos!=cursor+1 && npos!=cursor+1)
                    j = map_lv[b*8+a+1] ;
                    map_lv[b*8+a] = j ;
                    map_lv[b*8+a+1] = 12 ;
                    map_changed = 1 ;
                    a++ ;
                    cursor++ ;
                    move = SENSIBILIDAD ;
                    IF (cursor==bonus+1) bonus--; END
                  END
                END
              END
              // Check cursor moves -> LEFT
              IF (key(_LEFT) AND a>0 )
                IF ((b==0 AND a>2) OR b>0)
                  IF (pos!=cursor-1 && npos!=cursor-1)
                    j = map_lv[b*8+a-1] ;
                    map_lv[b*8+a] = j ;
                    map_lv[b*8+a-1] = 12 ;
                    map_changed = 1 ;
                    a-- ;
                    cursor-- ;
                    move = SENSIBILIDAD ;
                    IF (cursor==bonus+1) bonus++; END
                  END
                END
              END
            END

            // MOVEMENT SENSIBILITY
            IF (move>0) move-- ; END

            // UPDATE TIMERS
            IF (timer>=timeo)
              timer = 0 ;
              time-- ;
              define_region(1,225,85,time,5) ;
            END
            // RUNNING OUT OF TIME...
            IF (time==0)
              estado = E_TIMEOUT ;
            END
            // IS LEVEL FINISHED?
            IF (pos==64 && px==1)
              estado = E_SCORE ;
            END

            // EXIT GAME
            IF (key(_ESC)) estado=E_EXIT ; END

            IF (estado == E_TIMEOUT)

              signal(get_id(TYPE bola),s_kill) ;
              mid.flags = 4 ;
              txt = write(fbs,110,120,4,"TIME OUT!!!") ;
              FRAME(5000) ;
              delete_text(txt) ;
              mid.flags = 0 ;

              // reducing lives...
              lives-- ;
              IF (lives>=0)
                signal(lv[lives],S_KILL) ;
              END

              time = 75 ;
              define_region(1,225,85,75,5) ;
              estado = E_LEVEL ;
              timer=0 ;
              bola(42,28) ;
              pos = 2 ;

            END

            // HAS LIVES?
            IF (lives<0)
              estado = E_REPORT ;
            END

            FRAME ;

          END // LEVEL LOOP

          IF (estado == E_SCORE)

            signal(get_id(TYPE bola),s_kill) ;
            mid.flags = 4 ;
            txt = write(fbs,110,120,4,"WELL DONE!!!") ;
            FRAME(5000) ;
            delete_text(txt) ;
            mid.flags = 0 ;

            // increasing lives...
            lv[lives] = live(270+lives*10,62) ;
            lives++ ;
            time = 75 ;
            define_region(1,225,85,75,5) ;
            estado = E_GAME ; // generates next level...
            signal(mid,s_kill) ;
            signal(get_id(type bono),s_kill) ;
            unload_map(0,game_map) ;

          END

          IF (estado == E_REPORT)

            signal(get_id(TYPE bola),s_kill) ;
            mid.flags = 4 ;
            txt = write(fbs,110,120,4,"GAME OVER!!!") ;
            FRAME(5000) ;
            delete_text(txt) ;
            mid.flags = 0 ;
            signal(mid,s_kill) ;
            unload_map(0,game_map) ;
            delete_text(all_text) ;
//            delete_draw(all_drawing) ;
            let_me_alone() ;
            fade_off() ;
            estado = E_MENU ;
            WHILE (fading)
              FRAME ;
            END
            stop_song() ;

          END


        END

      END

    END

    IF (key(_ESC)) estado=E_EXIT ; END
    FRAME ;

  END

  // Clean up...
  clear_screen() ;
  let_me_alone() ;
  unload_fpg(fpgfile) ;

  // Graphics
  unload_map(0,game_map) ;
  FOR (i=0;i<17;i++)
    UNLOAD_MAP(0,blocks[i]) ;
  END
  // Modules
  stop_song() ;
  unload_song(module1) ;
  unload_song(module2) ;

  // Fonts
  unload_fnt(fb) ;


  exit("",0) ;

END

// The playing area...
PROCESS mapa()

PRIVATE

  INT n,m ;

BEGIN

  X = 9 ;
  Y = 20 ;
  GRAPH = game_map ;

  LOOP

    IF (map_changed)

      unload_map(0,game_map) ;
      game_map = new_map(199,199,8) ;
      set_center(0,game_map,0,0) ;
      map_clear(0,game_map,0) ;
      FOR (n=0;n<64;n++)

        m = map_lv[n] ;

        IF (m!=12)
          map_put(0,game_map,blocks[m],centros[n MOD 8],centros[n/8]) ;
        ELSE
          map_put(0,game_map,blocks[m],centros[n MOD 8],centros[n/8]) ;
        END

      END

    END

    graph = game_map ;

    FRAME ;

  END

END

// Your ball...
PROCESS bola(x,y)

PRIVATE

  speed = 1 ;
  dir = 2 ;
  inc = 0 ;
  tmpx,tmpy,tmpdir ;
  dirs[1] ;
  dircount ;

BEGIN

  graph = blocks[13] ;
  z = -50 ;
  px = 1 ;
  py = 1 ;

  LOOP

    IF (inc==8)
      // must check next direction...
      inc = 0 ;
      SWITCH (dir)

        CASE 1:
          tmpx = x ;
          tmpy = y - 2 ;
          py-- ;
        END

        CASE 2:
          tmpx = x - 2 ;
          tmpy = y ;
          px-- ;
        END

        CASE 3:
          tmpx = x ;
          tmpy = y + 10 ;
          py++ ;
        END

        CASE 4:
          tmpx = x + 10 ;
          tmpy = y ;
          px++ ;
        END

      END

      IF (map_get_pixel(0,game_map,tmpx-9,tmpy-20)!=0 || tmpx<9 || tmpy<20 || tmpx>208 || tmpy>219 )
        // Change directions... check dir+1/dir-1
        dircount = 0 ;
        tmpdir = dir+1 ;
        IF (tmpdir>4) tmpdir-=4 ; END // normalize
        SWITCH (tmpdir)

          CASE 1:
            tmpx = x ;
            tmpy = y - 2 ;
          END

          CASE 2:
            tmpx = x - 2 ;
            tmpy = y ;
          END

          CASE 3:
            tmpx = x ;
            tmpy = y + 10 ;
          END

          CASE 4:
            tmpx = x + 10 ;
            tmpy = y ;
          END

        END

        IF (map_get_pixel(0,game_map,tmpx-9,tmpy-20)==0 && tmpx>9 && tmpy>20 && tmpx<208 && tmpy<219)

          dirs[dircount] = tmpdir ;
          dircount++ ;

        END

        tmpdir = dir-1 ;
        IF (tmpdir==0) tmpdir+=4 ; END // normalize
        SWITCH (tmpdir)

          CASE 1:
            tmpx = x ;
            tmpy = y - 2 ;
          END

          CASE 2:
            tmpx = x - 2 ;
            tmpy = y ;
          END

          CASE 3:
            tmpx = x ;
            tmpy = y + 10 ;
          END

          CASE 4:
            tmpx = x + 10 ;
            tmpy = y ;
          END

        END

        IF (map_get_pixel(0,game_map,tmpx-9,tmpy-20)==0 && tmpx>9 && tmpy>20 && tmpx<208 && tmpy<219)

          dirs[dircount] = tmpdir ;
          dircount++ ;

        END

        IF (dircount!=0)
          dir = dirs[rand(0,dircount-1)] ;
        ELSE
          dir += 2 ;
          IF (dir>4) dir -= 4; END
        END

      END

    END

    SWITCH (dir)

      CASE 1:
        y -= speed ;
      END

      CASE 2:
        x -= speed ;
      END

      CASE 3:
        y += speed :
      END

      CASE 4:
        x += speed ;
      END

    END

    // fixing the 1 px line...
    IF (px<0 or px>2) inc=-1 ; END
    if (py<0 or py>2) inc=-1 ; END
    IF (px==-1)
      px=2 ;
      pos-- ;
    END
    IF (px==3)
      px=0 ;
      pos++ ;
    END
    IF (py==-1)
      py=2 ;
      pos -= 8 ;
    END
    IF (py==3)
      py=0 ;
      pos += 8 ;
    END
    npos = 0 ;
    IF (px==0 && dir==2)
      npos = pos-1 ;
    END
    IF (px==2 && dir==4)
      npos = pos+1 ;
    END
    IF (py==0 && dir==1)
      npos = pos-8 ;
    END
    IF (py==2 && dir==3)
      npos = pos+8 ;
    END
    inc += speed ;

    FRAME ;

  END

END

// Life markers
PROCESS live(x,y)

BEGIN

  graph = blocks[13] ;

  LOOP

    FRAME ;

  END

END

PROCESS time_counter()

BEGIN

  graph = blocks[15] ;
  region = 1 ;
  x = 225 ;
  y = 85 ;

  LOOP

    FRAME ;

  END

END

// Energy bar
PROCESS time_counter_g()

BEGIN

  flags = 4 ;
  graph = blocks[15] ;
  region = 0 ;
  x = 225 ;
  y = 85 ;

  LOOP

    FRAME ;

  END

END

// Energy cell
PROCESS bono()

BEGIN

  graph = blocks[16] ;

  timer[1] = 0 ;

  LOOP

    x = 17 + centros[bonus MOD 8] ;
    y = 28 + centros[bonus/8] ;

    IF (collision(TYPE bola))
      time+=20 ;
      IF (time>75) time=75; END
      define_region(1,225,85,time,5) ;
      BREAK ;
    END

    IF (timer[1]>=1500)
      BREAK ;
    END

    FRAME ;

  END

  timer[1] = 0 ;
  bonus = 0 ;

END
